<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>轮播图管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/adv/list">轮播图列表</a></li>
		<shiro:hasPermission name="youka:adv:view"><li><a href="${ctx}/youka/adv/form">轮播图添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="youkaAdv" action="${ctx}/youka/adv/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>标题</label>
				<form:input path="title" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>标题</th>
				<th>链接</th>
				<th>图片地址</th>
				<th>状态</th>
				<th>排序序号</th>
				<th>开始时间</th>
				<th>失效时间</th>
				<th>修改时间</th>
				<shiro:hasPermission name="youka:adv:save"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="youkaAdv" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>
					${youkaAdv.title}
				</td>
				<td>
					${youkaAdv.href}
				</td>
				<td>
					${youkaAdv.picture}
				</td>
				<td>
					<c:if test="${youkaAdv.status eq '0'}">下线</c:if>
					<c:if test="${youkaAdv.status eq '1'}">上线</c:if>
					<c:if test="${youkaAdv.status eq '2'}">已删除</c:if>
				</td>
				<td>
					${youkaAdv.weight}
				</td>
				<td>
					<fmt:formatDate value="${youkaAdv.beginTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${youkaAdv.expireTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${youkaAdv.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="youka:adv:save"><td>
    				<a href="${ctx}/youka/adv/form?id=${youkaAdv.id}">修改</a>
					<a href="${ctx}/youka/adv/delete?id=${youkaAdv.id}" onclick="return confirmx('确认要删除该单表吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>