/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.youka.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.youka.entity.YoukaFeedback;
import com.thinkgem.jeesite.modules.youka.service.YoukaFeedbackService;

/**
 * 单表生成Controller
 * @author tangting
 * @version 2018-06-20
 */
@Controller
@RequestMapping(value = "${adminPath}/youka/feedback")
public class YoukaFeedbackController extends BaseController {

	@Autowired
	private YoukaFeedbackService youkaFeedbackService;
	
	@ModelAttribute
	public YoukaFeedback get(@RequestParam(required=false) String id) {
		YoukaFeedback entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = youkaFeedbackService.get(id);
		}
		if (entity == null){
			entity = new YoukaFeedback();
		}
		return entity;
	}
	
	@RequiresPermissions("youka:feedback:view")
	@RequestMapping(value = {"list", ""})
	public String list(YoukaFeedback youkaFeedback, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<YoukaFeedback> page = youkaFeedbackService.findPage(new Page<YoukaFeedback>(request, response), youkaFeedback); 
		model.addAttribute("page", page);
		return "modules/youka/feedback/feedbackList";
	}

	@RequiresPermissions("youka:feedback:view")
	@RequestMapping(value = "form")
	public String form(YoukaFeedback youkaFeedback, Model model) {
		model.addAttribute("youkaFeedback", youkaFeedback);
		return "modules/youka/feedback/feedbackForm";
	}

	@RequiresPermissions("youka:feedback:edit")
	@RequestMapping(value = "save")
	public String save(YoukaFeedback youkaFeedback, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, youkaFeedback)){
			return form(youkaFeedback, model);
		}
		youkaFeedbackService.save(youkaFeedback);
		addMessage(redirectAttributes, "保存单表成功");
		return "redirect:"+Global.getAdminPath()+"/youka/feedback/?repage";
	}
	
	@RequiresPermissions("youka:feedback:edit")
	@RequestMapping(value = "delete")
	public String delete(YoukaFeedback youkaFeedback, RedirectAttributes redirectAttributes) {
		youkaFeedbackService.delete(youkaFeedback);
		addMessage(redirectAttributes, "删除该条反馈成功");
		return "redirect:"+Global.getAdminPath()+"/youka/feedback/?repage";
	}

}