package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDetailDao;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUserDetail;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author niehh
 * @Description:
 * @date 2018年03月07日 10:05
 */
@Service
@Transactional(readOnly = true)
public class YoukaUserDetailService extends CrudService<YoukaUserDetailDao, YoukaUserDetail> {

    public YoukaUserDetail getByUserCode(String userCode) {
        YoukaUserDetail youkaUserDetail = dao.getByUserCode(userCode);
        if(youkaUserDetail != null){
            if(youkaUserDetail.getIdCardFront() != null){
                youkaUserDetail.setIdCardFront(Global.IMAGE_SAVE_URL + youkaUserDetail.getIdCardFront());
            }
            if(youkaUserDetail.getIdCardBack() != null){
                youkaUserDetail.setIdCardBack(Global.IMAGE_SAVE_URL + youkaUserDetail.getIdCardBack());
            }
            if(youkaUserDetail.getIdCardHold() != null){
                youkaUserDetail.setIdCardHold(Global.IMAGE_SAVE_URL + youkaUserDetail.getIdCardHold());
            }
            if(youkaUserDetail.getIdCardPlace() != null){
                youkaUserDetail.setIdCardPlace(Global.IMAGE_SAVE_URL + youkaUserDetail.getIdCardPlace());
            }
            if(youkaUserDetail.getDebitCard() != null){
                youkaUserDetail.setDebitCard(Global.IMAGE_SAVE_URL + youkaUserDetail.getDebitCard());
            }
        }

        return youkaUserDetail;
    }
}
