package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.BaseService;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.thinkgem.jeesite.modules.youka.dao.YoukaBenefitDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDao;
import com.thinkgem.jeesite.modules.youka.entity.OrderEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaBenefit;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional(readOnly = true)
public class YoukaBenefitService extends CrudService<YoukaBenefitDao ,YoukaBenefit> {

    @Autowired
    private YoukaUserDao youkaUserDao;

    @Autowired
    private YoukaBenefitDao youkaBenefitDao;

    /**
     * 分润
     *
     * @param request
     * @return
     */
    public List<YoukaBenefit> getBenefitList(YoukaBenefit request) {

        return dao.findList(request);

    }


    // 通过时间修改分润的状态
    public Integer updateBenefitByDate(YoukaBenefit youkaBenefit) {
        return dao.updateBenefitByDate(youkaBenefit);
    }


    /**
     * 余额
     *
     * @param entity
     * @return
     */
    public String getBalance(YoukaBenefit entity) {

        // 总收益
        entity.setBenefitType("A");
        YoukaBenefit benefitEntityA = dao.getBenefitSum(entity);

        // 总提现
        entity.setBenefitType("M");
        YoukaBenefit benefitEntityM = dao.getBenefitSum(entity);

        // 余额 = 总收益-总提现
        if (benefitEntityA == null) {
            return "0.00";
        } else {
            if (benefitEntityA.getAmount() == null) {
                benefitEntityA.setAmount("0.00");
            }
            if (benefitEntityM == null) {
                return "0.00";
            } else {
                if (benefitEntityM.getAmount() == null) {
                    benefitEntityM.setAmount("0.00");
                }
                DecimalFormat df = new DecimalFormat("######0.00");
                return (df.format(Double.valueOf(benefitEntityA.getAmount()) - Double.valueOf(benefitEntityM.getAmount())));
            }
        }

    }


    public Page<YoukaBenefit> findPage(Page<YoukaBenefit> page, YoukaBenefit youkaBenefit) {
        //不同类型用户所看到分润不同
//        管理员看到的是所有的，王者，钻石看到的是自己的
//        youkaUserDao
        User user = UserUtils.getUser();
        if (!StringUtils.isBlank(user.getOffice().getName())) {
            youkaBenefit.setUserCode(user.getPhone());
        }
        if (user.getOffice().getName().equals("钻石用户")) {
            youkaBenefit.setCode("B");

        }
        Page<YoukaBenefit> pages = super.findPage(page,youkaBenefit);
        Map<String,String> map = new HashMap<>();
        if(page != null && pages.getList() != null && pages.getList().size()>0){
            for(YoukaBenefit youkaBenefit1:pages.getList()){
                if(StringUtils.isNotBlank(map.get(youkaBenefit1.getUserCode()))){
                    youkaBenefit1.setBalance(map.get(youkaBenefit1.getUserCode()));
                }else{
                    //设置余额
                    youkaBenefit1.setBalance(this.getBalance(youkaBenefit1));
                    map.put(youkaBenefit1.getUserCode(),youkaBenefit1.getBalance());
                }

            }
        }
        return pages;
    }

    public Page<YoukaBenefit> findPageUser(Page<YoukaBenefit> page, YoukaBenefit youkaBenefit){
        //不同类型用户所看到分润不同
//        管理员看到的是所有的，王者看到的是旗下所有钻石收益，钻石看到的是下一级推荐的收益
//        youkaUserDao
        User user = UserUtils.getUser();
        if(!StringUtils.isBlank(user.getOffice().getName()) ){

            if (user.getOffice().getName().equals("王者用户")){
                youkaBenefit.setUserCode(user.getPhone());
            }
            if (user.getOffice().getName().equals("钻石用户")){
                youkaBenefit.setUserCode(user.getPhone());

            }
        }
        Page<YoukaBenefit> pages = super.findPage(page,youkaBenefit);
        List<YoukaBenefit> list = page.getList();
        if (list.size()>0){
            for (YoukaBenefit entity:list) {
                YoukaUser youkaUser = youkaUserDao.getUserByOrderCode(entity.getOrderEntity().getPayCode());
                if (youkaUser!= null){
                    OrderEntity orderEntity = entity.getOrderEntity();
                    orderEntity.setNickname(youkaUser.getMobile());
                    entity.setOrderEntity(orderEntity);
                }
            }
        }

        return pages;
    }
}
