package com.thinkgem.jeesite.modules.youka.service;

import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.Office;
import com.thinkgem.jeesite.modules.sys.entity.Role;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.thinkgem.jeesite.modules.youka.dao.UpgradeUserDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDao;
import com.thinkgem.jeesite.modules.youka.entity.UpgradeUserEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service
@Transactional(readOnly = true)
public class UpgradeUserService  extends CrudService<UpgradeUserDao, UpgradeUserEntity> {

    @Autowired
    private YoukaUserService youkaUserService;

    @Autowired
    private SystemService systemService;


    @Transactional(readOnly = false, propagation = Propagation.REQUIRES_NEW)
    public void examine(UpgradeUserEntity upgradeUserEntity){
//        //升级钻石用户，建立新的前端账户
        YoukaUser youkaUser = youkaUserService.checkMobile(upgradeUserEntity.getMobile());
//        YoukaUser youkaUserNew = new YoukaUser();
//        youkaUserNew.setMobile(upgradeUserEntity.getAfterMobile());
//        youkaUserNew.setPassword(youkaUser.getPassword());
//        youkaUserNew.setRecommendedMobile(youkaUser.getRecommendedMobile());
//        youkaUserNew.setOrderCode(upgradeUserEntity.getOrderCode());
//        youkaUserNew.setLevel(upgradeUserEntity.getLevel());
//        User user = UserUtils.getUser();
//        if(StringUtils.isNotBlank(youkaUser.getRecommendedPath())){
//
//            youkaUserNew.setRecommendedPath(youkaUser.getRecommendedPath().substring(0,4));
//            if(StringUtils.isNotBlank(user.getName()) && user.getName().contains("userId:")){
//                youkaUserNew.setRecommendedPath(youkaUserNew.getRecommendedPath()+","+user.getName().substring(7)+",");
//            }
//        }

//        youkaUserService.save(youkaUserNew);
        //同时建立管理后台用户
        User bUser = new User();
        bUser.setCompany(new Office("48b56cabc6d64691b6f97c518bac76fd"));
        bUser.setOffice(new Office("153fd0952728416aa9d3e712dc525bf5"));
        bUser.setPassword(SystemService.entryptPassword(upgradeUserEntity.getAfterMobile()));//用户升级之后，管理后台密码为新的手机号码
        bUser.setPhone(upgradeUserEntity.getAfterMobile());
        List<Role> roleList = Lists.newArrayList();
        List<String> roleIdList = new ArrayList<>();
        roleIdList.add("5253e6070a7a456683d697a49980978a");
//                user.preInsert();
        for (Role r : systemService.findAllRole()){
            if (roleIdList.contains(r.getId())){
                roleList.add(r);
            }
        }
        bUser.setRoleList(roleList);
        bUser.setName("userId_"+youkaUser.getId());
        bUser.setLoginName(youkaUser.getMobile());
        bUser.setLoginFlag("1");
        bUser.setNo("121323");
        // 保存用户信息
        systemService.saveUser(bUser);


        upgradeUserEntity.setStatus("2");
        upgradeUserEntity.preUpdate();
        dao.update(upgradeUserEntity);

    }
}
