/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileUploadFilter
implements Filter {
    private static final String CONTENT_LENGTH = "content-length";
    private static final String JSESSIONID = "jsessionid";
    private static final String JSID_PARAM_NAME = "JSESSIONID";
    private static final String USER_SESSION_COOKIE_NAME = "sessionCookieName";
    private static final String USER_SESSION_PATH_PARAMETER_NAME = "sessionParameterName";
    private FilterConfig config = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String contentLength;
        if ("LoadCookies".equalsIgnoreCase(request.getParameter("command"))) {
            request.setAttribute("session.cookie.name", (Object)this.getSessionCookieName());
            request.setAttribute("session.parameter.name", (Object)this.getSessionParameterName());
        }
        if ("FILEUPLOAD".equalsIgnoreCase(request.getParameter("command")) && request instanceof HttpServletRequest && response instanceof HttpServletResponse && (contentLength = (httpRequest = (HttpServletRequest)request).getHeader(CONTENT_LENGTH)) != null && Integer.parseInt(contentLength) == 0) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            this.setSessionCookie((HttpServletResponse)response, httpRequest);
            return;
        }
        filterChain.doFilter(request, response);
    }

    private void setSessionCookie(HttpServletResponse httpResponse, HttpServletRequest httpRequest) {
        if (httpRequest.getParameter(this.getSessionParameterName()) != null) {
            Cookie userCookie = new Cookie(this.getSessionCookieName(), httpRequest.getParameter(this.getSessionParameterName()));
            httpResponse.addCookie(userCookie);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public void destroy() {
    }

    private String getSessionCookieName() {
        return this.config.getInitParameter(USER_SESSION_COOKIE_NAME) == null ? JSID_PARAM_NAME : this.config.getInitParameter(USER_SESSION_COOKIE_NAME);
    }

    private String getSessionParameterName() {
        return this.config.getInitParameter(USER_SESSION_PATH_PARAMETER_NAME) == null ? JSESSIONID : this.config.getInitParameter(USER_SESSION_PATH_PARAMETER_NAME);
    }
}

