/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.makers.ThumbnailMaker;

public final class ScaledThumbnailMaker
extends ThumbnailMaker {
    private static final String PARAM_SCALE = "scale";
    private double widthFactor;
    private double heightFactor;

    public ScaledThumbnailMaker() {
        this.ready.unset(PARAM_SCALE);
    }

    public ScaledThumbnailMaker(double d) {
        this();
        this.scale(d);
    }

    public ScaledThumbnailMaker(double d, double d2) {
        this();
        this.scale(d, d2);
    }

    public ScaledThumbnailMaker scale(double d) {
        return this.scale(d, d);
    }

    public ScaledThumbnailMaker scale(double d, double d2) {
        if (this.ready.isSet(PARAM_SCALE)) {
            throw new IllegalStateException("The scaling factor has already been set.");
        }
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("The scaling factor must be greater than zero.");
        }
        this.widthFactor = d;
        this.heightFactor = d2;
        this.ready.set(PARAM_SCALE);
        return this;
    }

    public BufferedImage make(BufferedImage bufferedImage) {
        int n = (int)Math.round((double)bufferedImage.getWidth() * this.widthFactor);
        int n2 = (int)Math.round((double)bufferedImage.getHeight() * this.heightFactor);
        n = n == 0 ? 1 : n;
        n2 = n2 == 0 ? 1 : n2;
        return super.makeThumbnail(bufferedImage, n, n2);
    }
}

