<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#no").focus();
			$("#inputForm").validate({

			
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$(".isNewDebit").click(function () {
				$(".isDebit").html("否");;
				$(".isNewDebit").show();
				$(".isNewDebit").val("N");
				$this = $(this);
				$this.closest("tr").find(".isDebit").html("是");
				$this.closest("tr").find(".isNewDebit").hide();
                $this.closest("tr").find(".isNewDebitInput").val("Y");
            });
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/youka/user/list">用户列表</a></li>
		<li class="active"><a href="${ctx}/youka/user/real/name/audit?id=${user.id}">用户<shiro:hasPermission name="sys:user:edit">修改</shiro:hasPermission><shiro:lacksPermission name="sys:user:edit"></shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="youkaUser" action="${ctx}/youka/user/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">头像:</label>
			<div class="controls">
				<form:hidden id="nameImage" path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="nameImage" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">用户登录名:</label>
			<div class="controls">
				<form:input path="nickname"  htmlEscape="false" maxlength="50" class="input-medium required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">用户类型:</label>
			<div class="controls">
				<c:if test="${youkaUser.level eq 'S'}">管理员</c:if>
				<c:if test="${youkaUser.level eq 'A'}">王者会员</c:if>
				<c:if test="${youkaUser.level eq 'B'}">钻石会员</c:if>
				<c:if test="${youkaUser.level eq 'C'}">黄金会员</c:if>
				<c:if test="${youkaUser.level eq 'D'}">白银会员</c:if>
				<c:if test="${youkaUser.level eq 'E'}">青铜会员</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">真实姓名:</label>
			<div class="controls">
				<form:input path="youkaUserDetail.realName"  htmlEscape="false" maxlength="50" class="input-medium" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证号:</label>
			<div class="controls">
				<form:input path="youkaUserDetail.idCard"  htmlEscape="false" maxlength="50" class="input-medium" />

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证地址:</label>
			<div class="controls">
				<form:input path="youkaUserDetail.idCardPlace"  htmlEscape="false" maxlength="50" class="input-medium" />
				<c:if test="${youkaUser.youkaUserDetail != null }">
					${youkaUser.youkaUserDetail.idCard}
				</c:if>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">身份证图片:</label>
			<div class="controls">
				<form:hidden id="idCardFront" path="youkaUserDetail.idCardFront" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="idCardFront" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
				<form:hidden id="idCardBack" path="youkaUserDetail.idCardBack" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="idCardBack" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>

			</div>
		</div>

		<div class="control-group">
			<label class="control-label">手持身份证图片:</label>
			<div class="controls">
				<form:hidden id="idCardHold" path="youkaUserDetail.idCardHold" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="idCardHold" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>

			</div>
		</div>

		<div class="control-group">
			<label class="control-label">银行卡正面:</label>
			<div class="controls">
				<form:hidden id="debitCard" path="youkaUserDetail.debitCard" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="debitCard" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">银行卡:</label>
			<div class="controls">
				<table id="contentTable" class="table table-striped table-bordered" style="display:inline-block;">
					<thead><tr><th>序号</th><th style="width: 100px;">银行卡名称</th><th >银行卡类型</th><th >银行卡号</th><th >开户地址</th><th >开户支行</th><th >是否为结算卡</th><%--<th>角色</th> --%><th style="width: 80px;">操作</th></tr></thead>
					<tbody>
					<c:forEach items="${youkaUser.youkaCardEntityList}" var="card" varStatus="indexs">
						<tr>
							<td>${indexs.index}</td>
							<td>${card.belongBank}</td>
							<td>
								<c:if test="${card.cardType eq 'D'}">储蓄卡</c:if>
								<c:if test="${card.cardType eq 'C'}">信用卡</c:if>
							</td>
							<td>${card.cardNo}</td>
							<td>
								${card.cardPlace}
							</td>
							<td>
								${card.cardBank}
							</td>
							<td class="isDebit">
								<c:if test="${card.isDebit eq 'Y'}">是</c:if>
								<c:if test="${card.isDebit eq 'N'}">否</c:if>
							</td>
							<td>
								<input name="youkaCardEntityList[${indexs.index}].isDebit" value="${card.isDebit}" style="display: none;"/>
								<input name="youkaCardEntityList[${indexs.index}].id" value="${card.id}" style="display: none;"/>
								<input name="youkaCardEntityList[${indexs.index}].isNewDebit" value="${card.isDebit}" style="display: none;" class="isNewDebitInput"/>
								<c:if test="${card.isDebit eq 'N'}"><input class="isNewDebit" type="button" value="设置成结算卡"></c:if>
								<c:if test="${card.isDebit eq 'Y'}"><input class="isNewDebit" type="button" value="设置成结算卡" style="display: none"></c:if>
							</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:user:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>