package com.thinkgem.jeesite.modules.youka.web;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.youka.entity.UserLevel;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import com.thinkgem.jeesite.modules.youka.service.YoukaRateService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * @author niehh
 * @Description:
 * @date 2018年03月09日 14:24
 */
@RestController
@RequestMapping(value = "${adminPath}/youka/rateBody")
public class YoukaRateBodyController{


    @Autowired
    private YoukaRateService youkaRateService;

    @RequiresPermissions("youka:rate:save")
    @ResponseBody
    @RequestMapping(value = "saveAll")
    public String save(HttpServletRequest request,Model model, RedirectAttributes redirectAttributes){

        String listStr = request.getParameter("lists");
        List<YoukaRate> list = JSONArray.parseArray(listStr,YoukaRate.class);
        if(list!=null && list.size()>0){

            for(YoukaRate youkaRate:list){
                if(youkaRate ==null || StringUtils.isBlank(youkaRate.getUserLevel()) ){
                    return "false";
                }
                try{
                    youkaRateService.saveRate(youkaRate);
                }catch (Exception e){
                    e.printStackTrace();
                    return "false";
                }
            }

        }else{
            return "false";
        }
        return "true";
    }

}
