package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.youka.entity.UserLevel;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import com.thinkgem.jeesite.modules.youka.service.YoukaRateService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author niehh
 * @Description:
 * @date 2018年03月09日 14:24
 */
@Controller
@RequestMapping(value = "${adminPath}/youka/rate")
public class YoukaRateController  extends BaseController {


    @Autowired
    private YoukaRateService youkaRateService;

//    @RequiresPermissions("youka:rate:view")
//    @RequestMapping(value = "form")
//    public String form(YoukaRate youkaRate, Model model){
//
//        if(youkaRate==null){
//            youkaRate = new YoukaRate();
//        }
//        if(StringUtils.isBlank(youkaRate.getUserLevel()) ){
//            youkaRate.setUserLevel("S");
//        }
//        if(StringUtils.isBlank(youkaRate.getPayMethod())){
//            youkaRate.setPayMethod("quick");
//        }
//        if(StringUtils.isBlank(youkaRate.getPayChannel())){
//            youkaRate.setPayChannel("quick_no_integral");
//        }
//        List<YoukaRate> list = youkaRateService.getRateByUserLevel(youkaRate);
//
//        model.addAttribute("list",list);
//
//        return "";
//    }

    @RequiresPermissions("youka:rate:view")
    @RequestMapping(value = "list")
    public String list(YoukaRate youkaRate, Model model){

        if(youkaRate==null){
            youkaRate = new YoukaRate();
        }

        if(StringUtils.isBlank(youkaRate.getPayMethod())){
            youkaRate.setPayMethod("quick");
        }
        if(StringUtils.isBlank(youkaRate.getPayChannel())){
            youkaRate.setPayChannel("quick_no_integral");
        }
        Map<String,YoukaRate> map = youkaRateService.getRateByUserLevel(youkaRate);

        model.addAttribute("map",map);

        List<UserLevel> list = new ArrayList<>();

        model.addAttribute("userLevels",UserLevel.getList());
        model.addAttribute("youkaRate",youkaRate);
        model.addAttribute("HL3rates", DictUtils.getDictList("HL3_rate"));

        return "modules/youka/rate/rateList";
    }

    @RequiresPermissions("youka:rate:save")
    @RequestMapping(value = "save")
    public String save(YoukaRate youkaRate, Model model, RedirectAttributes redirectAttributes){
        if(youkaRate ==null || StringUtils.isBlank(youkaRate.getUserLevel()) ){
            addMessage(model, "信息为空");
            return list(youkaRate, model);
        }
        try{
            youkaRateService.saveRate(youkaRate);
        }catch (Exception e){
            addMessage(model, "保存失败");
            e.printStackTrace();
            return list(youkaRate, model);
        }
        return list(youkaRate, model);
    }

}
