package com.thinkgem.jeesite.modules.youka.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import java.util.List;

/**
 * @author niehh
 * @Description: 优卡用户
 * @date 2018年03月05日 11:08
 */
public class YoukaUser extends DataEntity<YoukaUser> {
    
    private String code; //  varchar(64) DEFAULT NULL COMMENT '唯一编码',
    private String nickname; //  varchar(200) DEFAULT NULL COMMENT '昵称',
    private String subMerchantId; //  varchar(64) DEFAULT NULL COMMENT '（结算卡的）子商户号',
    private String level; //  varchar(1) DEFAULT NULL COMMENT '用户等级 S管理员 A王者 B钻石 C黄金 D白银 E青铜',
    private String mobile; //  varchar(11) DEFAULT NULL COMMENT '手机号',
    private String password; //
    private String avatar; //  varchar(500) DEFAULT NULL COMMENT '头像',
    private String recommendedMobile; //  varchar(255) DEFAULT NULL COMMENT '推荐人手机号',
    private String recommendedPath; //  varchar(255) DEFAULT NULL COMMENT '推荐人路径',
    private String belongTo; //  varchar(255) DEFAULT NULL COMMENT '商户来源 B佰邦达 S盛世互通',
    private String status; //  varchar(1) DEFAULT NULL COMMENT '状态 0未实名 1审核中 2已实名',

    private YoukaUserDetail youkaUserDetail;

    private List<YoukaCardEntity> youkaCardEntityList;

    public YoukaUser(){

    }
    public YoukaUser(String code, String subMerchantId, String mobile, String password, String recommendedMobile, String recommendedPath, String belongTo) {
        this.setCode(code);
        this.nickname = "E_" + mobile;
        this.subMerchantId = subMerchantId;
        this.level = "E";
        this.mobile = mobile;
        this.password = password;
        this.avatar = "";
        this.recommendedMobile = recommendedMobile;
        this.recommendedPath = recommendedPath;
        this.belongTo = belongTo;
        this.status = "0";

    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getSubMerchantId() {
        return subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getRecommendedMobile() {
        return recommendedMobile;
    }

    public void setRecommendedMobile(String recommendedMobile) {
        this.recommendedMobile = recommendedMobile;
    }

    public String getRecommendedPath() {
        return recommendedPath;
    }

    public void setRecommendedPath(String recommendedPath) {
        this.recommendedPath = recommendedPath;
    }

    public String getBelongTo() {
        return belongTo;
    }

    public void setBelongTo(String belongTo) {
        this.belongTo = belongTo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public YoukaUserDetail getYoukaUserDetail() {
        return youkaUserDetail;
    }

    public void setYoukaUserDetail(YoukaUserDetail youkaUserDetail) {
        this.youkaUserDetail = youkaUserDetail;
    }

    public List<YoukaCardEntity> getYoukaCardEntityList() {
        return youkaCardEntityList;
    }

    public void setYoukaCardEntityList(List<YoukaCardEntity> youkaCardEntityList) {
        this.youkaCardEntityList = youkaCardEntityList;
    }
}
