package com.thinkgem.jeesite.modules.pay.juhezhong.utils;

import com.thinkgem.jeesite.common.constant.ComCode;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author lsw
 * @version 1.0
 * @date 2016年1月3日
 * @desc 日期工具类
 */
public class DateUtil {
    /**
     * 将时间格式化成指定的字符串
     *
     * @param date
     * @param ftm
     * @return
     */
    public static String format2str(Date date, String ftm) {
        return new SimpleDateFormat(ftm).format(date);
    }

    /**
     * 装字符串格式化成指定日期时间
     *
     * @param value
     * @param fmt
     * @return
     */
    public static Date string2Date(String value, String fmt) {
        try {
            return new SimpleDateFormat(fmt).parse(value);
        } catch (ParseException e) {
        }
        return new Date();
    }


    /**
     * 检验当前时间是否在一个区间范围内
     * @return
     */
    public static boolean checkTimeIsDuration() {
        Boolean flag = false;
        String now = ComCode.HHMMSS.format(new Date());
        Date time;
        try {
            time = ComCode.HHMMSS.parse(now);
            Date start = ComCode.HHMMSS.parse("06:00:00");
            Date end = ComCode.HHMMSS.parse("22:00:00");
            if (isInTimeDuration(time, start, end)) {
                flag = true;
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return flag;
    }

    /**
     * 判断当前时间是否在[startTime, endTime]区间
     *
     * @param nowTime   当前时间
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    public static boolean isInTimeDuration(Date nowTime, Date startTime, Date endTime) {
        //首先判断是否与收尾时间相同，相同直接返回
        if (nowTime.getTime() == startTime.getTime()
                || nowTime.getTime() == endTime.getTime()) {
            return true;
        }

        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);

        if (date.after(begin) && date.before(end)) {
            return true;
        } else {
            return false;
        }
    }
}