package com.thinkgem.jeesite.modules.homepage.service;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.homepage.bean.NoticeRequest;
import com.thinkgem.jeesite.modules.homepage.dao.NoticeDao;
import com.thinkgem.jeesite.modules.homepage.entity.NoticeEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class NoticeService {

    @Autowired
    private NoticeDao noticeDao;

    public List<NoticeEntity> getNotice(NoticeRequest request) throws Exception {
        List<NoticeEntity> notice = noticeDao.getNotice(request);
        if(notice.size()>0){
            for (NoticeEntity entity: notice) {
                if(!StringUtils.isBlank(entity.getContent()) && entity.getContent().contains("/youka-manage/")){
                    String replace = entity.getContent().replace("/youka-manage/", "http://youkapay.com/youka-manage/");
                    entity.setContent(replace);
                }
            }
        }
        return notice;
    }
}
