package com.thinkgem.jeesite.modules.pay.juhezhong.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.JuhezhongUtils;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.*;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.HttpUtil;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.MakeOrderNum;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.SignUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Map;

/**
 * HL4通道--https://github.com/juhezhong/quickPayDemo
 */
@Service
@Lazy(false)
@Transactional
public class JuHeZhongPayService {

/**
 * 2018/05/31
 * 快捷B接口
 *
 * @return
 */
public JSONObject quickBPay ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.QUICK_PAY , params );
    return JSONObject.parseObject ( respStr );
}

/**
 * 2018/05/31
 * 查询订单接口
 *
 * @return
 */
public JSONObject orderQuery ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.ORDER_QUERY , params );
    return JSONObject.parseObject ( respStr );
}

/**
 * 2018/05/31
 * 银联WAP快捷（借）
 *
 * @return
 */
public JSONObject quickWebPay ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.QUICK_WEB_PAY , params );
    return JSONObject.parseObject ( respStr );
}

    /**
     * 注册子商户
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject register(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.MERCHANT_REG_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新费率
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateRate(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.RATE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新结算信息
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateSettle(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.SETTLE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 快捷支付
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject quickPay(ApiQuickPayDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }


    /**
     * 快捷支付 无积分
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject quickPay(QuickDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        System.out.println(params);
        String signBefore = SignUtils.signBefore(params);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }
    public JSONObject quickPay(JuhezhongDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        System.out.println(params);
        String signBefore = SignUtils.signBefore(params);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        System.out.println("sign2:"+sign);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }

    public JSONObject quickPay(JSONObject dto)throws Exception{
        String signBefore = SignUtils.signBefore(dto);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        System.out.println("sign:"+sign);
        dto.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, dto);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 查询订单状态
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(ApiQuickPayDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.ORDER_QUERY_URL, params);

        return JSONObject.parseObject(respStr);
    }

    /**
     * 查询订单状态  无积分
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(CommonDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_ORDER_QUERY_URL, params);
        return JSONObject.parseObject(respStr);
    }

    public static void main (String[] args ) throws Exception {
//        JuhezhongDto dto = new JuhezhongDto();
//        dto.setOrderId(MakeOrderNum.makeOrderNum());//非订单号
//        dto.setMerchantId(ComCode.MERCHANT_ID);//商户号
//
//        dto.setAmount(10000);//订单金额,单位是分
//        dto.setTrxType(3);//交易类型，默认传3
//        dto.setType(6);//5 借记卡 只能 D0 6 贷记卡 D0 t1
//        dto.setBankNo("6217000066011457475");//支付卡号
//        dto.setCvn2("065");//安全码
//        dto.setPhone("15902202472");//支付卡预留手机号
//        dto.setExpired("0528");//信用卡有效期(MMYY)
//        dto.setUserFee(200);//手续费 单位：分 ，D0 业务必传
//          if(dto.getType() == 6){
//
//              dto.setSettleBankName("建设银行");//结算银行 D0 业务必传
//              dto.setSettleBankNo("6217000066011457475");//一个身份证只能对应一个结算卡 D0 业务必传
//              dto.setSettleBankPhone("13821934497");//结算卡预留手机号 D0 业务必传
//              dto.setName("李波");//开户名 D0 业务必传
//              dto.setCertificateCode("53250219850831031X");//开户人身份证号 D0 业务必传
//          }
//        dto.setMerchantKey(ComCode.MERCHANT_KEY);
//        dto.setNotifyUrl("http://youkapay.com:8080/youka-api/api/pay/notifyQuickPay");//通知url
//        dto.setFrontUrl("http://youkapay.com:8080/youka-api/api/pay/notifyQuickPay");//前台地址url(保留)
//        dto.setTimestamp(System.currentTimeMillis());
//        System.out.println(new JuHeZhongPayService().quickBPay(dto));

//       String order  =  MakeOrderNum.makeOrderNum();
//        JSONObject dto=new JSONObject();
//        dto.put("orderId",order);//订单号
//        dto.put("merchantId",ComCode.MERCHANT_ID);//商户号
//        dto.put("amount",1000L);//交易金额  单位 分
//        dto.put("trxType",3);//交易类型  默认2   T1(2,"T1"), D0(3,"D0");
//        dto.put("type",6);// 5 借记卡 只能 d0      6 贷记卡 t1 d0
//        dto.put("bankNo","6282161411286681");//支付卡号
//        dto.put("cvn2","913");//支付卡号
//        dto.put("expired","0421");//支付卡号
//        dto.put("phone","15902202472");//支付卡预留手机号
//        dto.put("userFee",200);//手续费  单位分
//        if(dto.getInteger("type")==6){
//            dto.put("settleBankName","建设银行");//结算银行
//            dto.put("settleBankNo","6217000066011457475");//结算卡号
//            dto.put("settleBankPhone","15902202472");//结算卡预留手机号
//            dto.put("name","唐挺");//结算账户
//            dto.put("certificateCode","510623198809184419");//身份证号
//
//        }
//        dto.put("merchantKey",ComCode.MERCHANT_KEY);//商户key
//        dto.put("notifyUrl","http://youkapay.com:8080/youka-api/api/pay/notifyQuickPay");//通知url
//        dto.put("frontUrl","http://youkapay.com:8080/youka-api/api/pay/notifyQuickPay");//通知url
//        dto.put("timestamp",System.currentTimeMillis());//时间戳
//        System.out.println(new JuHeZhongPayService().quickPay(dto));

        //查询订单
        JuhezhongDto a = new JuhezhongDto ( );
        a.setOrderId ( "20180606105801173000" );
        a.setMerchantId ( ComCode.MERCHANT_ID );
        a.setMerchantKey ( ComCode.MERCHANT_KEY );
        a.setTimestamp ( System.currentTimeMillis ( ) );
        System.out.println ( "Json格式:" + new JuHeZhongPayService ( ).orderQuery ( a ) );

//        MerchantDto dto = new MerchantDto();
//        dto.setMerchantId(ComCode.MERCHANT_ID);
//        dto.setOrderId(IdGen.uuid());//不会产生交易订单
//        dto.setIdType("01"); // 根据文档说明，证件类型固定为01
//        dto.setAccName("唐挺");
//        dto.setAccType(1);//1 对私  2对公
//        dto.setAccNo("6217000060031684713");
//        dto.setAccProvince("天津市");
//        dto.setAccCity("天津");
//        dto.setBankCode("建设银行");
//        dto.setMobile("15902202472");
//        dto.setIdNo("6217000066011457475");
//        dto.setSettleRate(new BigDecimal(0));
//        dto.setExtraRate(new BigDecimal(ComCode.EXTRA_RATE));
//        dto.setTimestamp(System.currentTimeMillis());
//        dto.setMerchantKey(ComCode.MERCHANT_KEY);
//        System.out.println("结果："+new JuHeZhongPayService().register(dto));
    }

//    public static void main (String[] args) throws Exception {
////        ApiQuickPayDto request = new ApiQuickPayDto();
////        request.setAmount(10L);
////        request.setBody("23");
////        request.setFrontUrl("");
////        request.setNotifyUrl("");
////        request.setType(0);
////        request.setName("");
////        request.setUrl("");
////
////        JuHeZhongPayService juHeZhongPayService = new JuHeZhongPayService();
////        System.out.println(juHeZhongPayService.quickPay(request).toString());
//        ApiQuickPayDto dto = new ApiQuickPayDto();
//        dto.setOrderId("Dy58WqJG3MmNpSpQMq3wKZV55OiO48asPzRp4YUBBZUsVEiow7q6CZTQqwrBTl4k");
//        dto.setMerchantId(ComCode.MERCHANT_ID);
//        dto.setMerchantKey(ComCode.MERCHANT_KEY);
//        dto.setTimestamp(System.currentTimeMillis());
//
//        Map<String, Object> params = Bean2Map.Entity2Map(dto);
//        String signBefore = SignUtils.signBefore(params);
//        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
//        params.put("sign", sign);
//        String respStr = HttpUtil.post(ComCode.HOST + ComCode.ORDER_QUERY_URL, params);
//
//        System.out.println(respStr);
//
//    }
}
