/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

class FDBigInt {
    int nWords;
    int[] data;

    FDBigInt(int n) {
        this.nWords = 1;
        this.data = new int[1];
        this.data[0] = n;
    }

    FDBigInt(long l) {
        this.data = new int[2];
        this.data[0] = (int)l;
        this.data[1] = (int)(l >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
    }

    FDBigInt(FDBigInt fDBigInt) {
        this.nWords = fDBigInt.nWords;
        this.data = new int[this.nWords];
        System.arraycopy(fDBigInt.data, 0, this.data, 0, this.nWords);
    }

    FDBigInt(int[] nArray, int n) {
        this.data = nArray;
        this.nWords = n;
    }

    void lshiftMe(int n) throws IllegalArgumentException {
        if (n <= 0) {
            if (n == 0) {
                return;
            }
            throw new IllegalArgumentException("negative shift count");
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = 32 - n3;
        int[] nArray = this.data;
        int[] nArray2 = this.data;
        if (this.nWords + n2 + 1 > nArray.length) {
            nArray = new int[this.nWords + n2 + 1];
        }
        int n5 = this.nWords + n2;
        int n6 = this.nWords - 1;
        if (n3 == 0) {
            System.arraycopy(nArray2, 0, nArray, n2, this.nWords);
            n5 = n2 - 1;
        } else {
            nArray[n5--] = nArray2[n6] >>> n4;
            while (n6 >= 1) {
                nArray[n5--] = nArray2[n6] << n3 | nArray2[--n6] >>> n4;
            }
            nArray[n5--] = nArray2[n6] << n3;
        }
        while (n5 >= 0) {
            nArray[n5--] = 0;
        }
        this.data = nArray;
        this.nWords += n2 + 1;
        while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
            --this.nWords;
        }
    }

    int normalizeMe() throws IllegalArgumentException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = this.nWords - 1; n >= 0 && (n4 = this.data[n]) == 0; --n) {
            ++n2;
        }
        if (n < 0) {
            throw new IllegalArgumentException("zero value");
        }
        this.nWords -= n2;
        if ((n4 & 0xF0000000) != 0) {
            n3 = 32;
            while ((n4 & 0xF0000000) != 0) {
                n4 >>>= 1;
                --n3;
            }
        } else {
            while (n4 <= 1048575) {
                n4 <<= 8;
                n3 += 8;
            }
            while (n4 <= 0x7FFFFFF) {
                n4 <<= 1;
                ++n3;
            }
        }
        if (n3 != 0) {
            this.lshiftMe(n3);
        }
        return n3;
    }

    FDBigInt mult(int n) {
        long l = n;
        int[] nArray = new int[l * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
        long l2 = 0L;
        for (int i = 0; i < this.nWords; ++i) {
            nArray[i] = (int)(l2 += l * ((long)this.data[i] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        if (l2 == 0L) {
            return new FDBigInt(nArray, this.nWords);
        }
        nArray[this.nWords] = (int)l2;
        return new FDBigInt(nArray, this.nWords + 1);
    }

    FDBigInt mult(FDBigInt fDBigInt) {
        int n;
        int[] nArray = new int[this.nWords + fDBigInt.nWords];
        for (n = 0; n < this.nWords; ++n) {
            long l = (long)this.data[n] & 0xFFFFFFFFL;
            long l2 = 0L;
            for (int i = 0; i < fDBigInt.nWords; ++i) {
                nArray[n + i] = (int)(l2 += ((long)nArray[n + i] & 0xFFFFFFFFL) + l * ((long)fDBigInt.data[i] & 0xFFFFFFFFL));
                l2 >>>= 32;
            }
            nArray[n + i] = (int)l2;
        }
        for (n = nArray.length - 1; n > 0 && nArray[n] == 0; --n) {
        }
        return new FDBigInt(nArray, n + 1);
    }

    FDBigInt add(FDBigInt fDBigInt) {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int[] nArray2;
        long l = 0L;
        if (this.nWords >= fDBigInt.nWords) {
            nArray2 = this.data;
            n3 = this.nWords;
            nArray = fDBigInt.data;
            n2 = fDBigInt.nWords;
        } else {
            nArray2 = fDBigInt.data;
            n3 = fDBigInt.nWords;
            nArray = this.data;
            n2 = this.nWords;
        }
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            l += (long)nArray2[n] & 0xFFFFFFFFL;
            if (n < n2) {
                l += (long)nArray[n] & 0xFFFFFFFFL;
            }
            nArray3[n] = (int)l;
            l >>= 32;
        }
        if (l != 0L) {
            int[] nArray4 = new int[nArray3.length + 1];
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
            nArray4[n++] = (int)l;
            return new FDBigInt(nArray4, n);
        }
        return new FDBigInt(nArray3, n);
    }

    int cmp(FDBigInt fDBigInt) {
        int n;
        int n2;
        if (this.nWords > fDBigInt.nWords) {
            n2 = fDBigInt.nWords - 1;
            for (n = this.nWords - 1; n > n2; --n) {
                if (this.data[n] == 0) continue;
                return 1;
            }
        } else if (this.nWords < fDBigInt.nWords) {
            n2 = this.nWords - 1;
            for (n = fDBigInt.nWords - 1; n > n2; --n) {
                if (fDBigInt.data[n] == 0) continue;
                return -1;
            }
        } else {
            n = this.nWords - 1;
        }
        while (n > 0 && this.data[n] == fDBigInt.data[n]) {
            --n;
        }
        n2 = this.data[n];
        int n3 = fDBigInt.data[n];
        if (n2 < 0) {
            if (n3 < 0) {
                return n2 - n3;
            }
            return 1;
        }
        if (n3 < 0) {
            return -1;
        }
        return n2 - n3;
    }

    int quoRemIteration(FDBigInt fDBigInt) throws IllegalArgumentException {
        int n;
        if (this.nWords != fDBigInt.nWords) {
            throw new IllegalArgumentException("disparate values");
        }
        int n2 = this.nWords - 1;
        long l = ((long)this.data[n2] & 0xFFFFFFFFL) / (long)fDBigInt.data[n2];
        long l2 = 0L;
        for (int i = 0; i <= n2; ++i) {
            this.data[i] = (int)(l2 += ((long)this.data[i] & 0xFFFFFFFFL) - l * ((long)fDBigInt.data[i] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        if (l2 != 0L) {
            long l3 = 0L;
            while (l3 == 0L) {
                l3 = 0L;
                for (n = 0; n <= n2; ++n) {
                    this.data[n] = (int)(l3 += ((long)this.data[n] & 0xFFFFFFFFL) + ((long)fDBigInt.data[n] & 0xFFFFFFFFL));
                    l3 >>= 32;
                }
                if (l3 != 0L && l3 != 1L) {
                    throw new RuntimeException("Assertion botch: " + l3 + " carry out of division correction");
                }
                --l;
            }
        }
        long l4 = 0L;
        for (n = 0; n <= n2; ++n) {
            this.data[n] = (int)(l4 += 10L * ((long)this.data[n] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        if (l4 != 0L) {
            throw new RuntimeException("Assertion botch: carry out of *10");
        }
        return (int)l;
    }
}

