package com.thinkgem.jeesite.modules.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.thinkgem.jeesite.common.config.Global;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.fluent.Request;


/**
 * 演示明码发送短信，不建议在生产环境使用。但可以在浏览器上手动测试
 */
public class SendDemo {

//	public static void main(String[] args) throws Exception {
//
//		// ====================================================================
//		// 本例子只是用于演示，请不要在实际生产中使用
//		// ====================================================================
//
//		// 必须的验证参数
//		String username = Global.getConfig("message.username");
//		String password = Global.getConfig("message.password");
//		String url = Global.getConfig("message.url");
//
//		// 短信相关的必须参数
//		String mobile = "13722537737";
//		String extendCode = "4443";
//		String message = "测试明码验证，不安全【XX公司】";
//
//		// 装配GET所需的参数
//		StringBuilder sb = new StringBuilder(2000);
//		sb.append(url);
//		sb.append("?dc=15"); // 表明发送的是中文
//		sb.append("&sm=").append( URLEncoder.encode(message, "utf8") );
//		sb.append("&da=").append( mobile );
//		sb.append("&sa=").append( extendCode );
//		sb.append("&un=").append( username );
//		sb.append("&pw=").append(URLEncoder.encode(password,"utf8")  ); // 这里采用明码验证方式，不安全；签名方式请参看SendWithSign
//		sb.append("&tf=3"); // 表示短信内容为 urlencode+utf8
//
//
//		String request = sb.toString();
//		System.out.println( request );
//
//		// 以GET方式发起请求
//		String result = Request.Get( request ).execute().returnContent().asString();
//
//		System.out.println( result );
//	}


    public static void main(String[] args ) throws NoSuchAlgorithmException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = sdf.format(new Date());
        //		// 必须的验证参数
		String username = Global.getConfig("message.username");
		String password = Global.getConfig("message.password");
		String url = Global.getConfig("message.url");

		// 短信相关的必须参数
		String mobile = "13722537737";
		String extendCode = "4443";
		String message = "测试明码验证，不安全【XX公司】";

        int dataCoding = 15; // UNICODE 编码
        int responseFormat = 2; // 返回格式为 Json 格式

        long externalId = 0x123456789L; // 自定义消int dataCoding = 8; // UNICODE 编码
        int transferEncoding = 3; // URLEncode+UTFint responseFormat = 2; // 返回格式为 Json 格String message = "这是一条测试短信,返回 J// 计算密码摘要
//        SimpleDateFormat sdf = new SimpleDateFormString timestamp = sdf.format(new Date() );
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update( username.getBytes("utf8") );
        md5.update( password.getBytes("utf8") );
        md5.update( timestamp.getBytes("utf8") );
        md5.update( message.getBytes("utf8") );
        password = Base64.encodeBase64String( md5.digest() );
        StringBuilder sb = new StringBuilder();
        sb.append(url)
                .append("?un=").append( username )
                .append("&pw=").append( URLEncoder.encode(password,"utf8") )
                .append("&ts=").append( timestamp )
                .append("&da=").append( mobile )
                .append("&sa=").append( extendCode )
                .append("&ex=").append( externalId )
                .append("&dc=").append( dataCoding )
                .append("&tf=").append( transferEncoding )
                .append("&rf=").append( responseFormat )
                .append("&sm=").append( URLEncoder.encode(message, "utf8") );
        String req = sb.toString();
        System.out.println("request: " + req);
        // 以GET方式发起请求
		String result = Request.Get( req ).execute().returnContent().asString();
        System.out.println( "response: " + result );
    }

}
