package com.thinkgem.jeesite.modules.pay.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.pay.service.PayApiService;
import com.thinkgem.jeesite.modules.user.bean.JuHeZhongPayRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付相关
 */
@RestController
@RequestMapping("/api/pay")
public class PayApiController {
    @Autowired
    private PayApiService payService;

    /**
     * 快捷支付
     *
     * @param request
     * @return
     */
    @PostMapping("/quickPay")
    public Response quickPay(JuHeZhongPayRequest request) {
        Response resp = new Response();
        try {
            payService.quickPay(request);
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }


}
