package com.thinkgem.jeesite.modules.pay.api;

import com.thinkgem.jeesite.common.baseBean.Request;
import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.pay.bean.OrderRequest;
import com.thinkgem.jeesite.modules.pay.entity.BalanceEntity;
import com.thinkgem.jeesite.modules.pay.entity.BenefitEntity;
import com.thinkgem.jeesite.modules.pay.service.BenefitSevice;
import com.thinkgem.jeesite.modules.user.entity.UserEntity;
import com.thinkgem.jeesite.modules.user.service.UserApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author niehh
 * @Description:分润相关
 * @date 2018年03月16日 14:32
 */
@RestController
@RequestMapping("/api/benefit")
public class BenefitController{

    @Autowired
    private BenefitSevice benefitSevice;

    @Autowired
    private UserApiService userService;


    /**
     * 余额查询
     * @param request
     * @return
     */
    @PostMapping("/getBalance")
    public Response getBalance(Request request){

        Response response = new Response();
        if(StringUtils.isBlank(request.getSubMerchantCode())){
            response.setStatus(ComCode.STATUS_CODE_4001);
            response.setMessage(ComCode.STATUS_CODE_4001_DESC);
            return response;
        }
        try {
            BenefitEntity entity  =  new BenefitEntity();
            entity.setUserCode(request.getSubMerchantCode());
            BalanceEntity balanceEntity = null;
//            //高级别用户
//                //1.获取的下线，在成为高级别用户以后的所有收益----即总收益
//            UserEntity userInfo = userService.getUserInfo(request);
//            if (userInfo.getLevel().equals("A")||userInfo.getLevel().equals("B")){
//                //王者、钻石用户
//                balanceEntity = benefitSevice.getBalanceHighLevel(entity,userInfo);
//            }else{
                //非高级别用户
                balanceEntity = benefitSevice.getBalance(entity);
//            }
            response.setData(balanceEntity);
            response.setStatus(ComCode.STATUS_CODE_2000);
            response.setMessage(ComCode.STATUS_CODE_2000_DESC);
            return response;
        }catch (Exception e){
            response.setStatus(ComCode.STATUS_CODE_9998);
            response.setMessage(ComCode.STATUS_CODE_9998_DESC);
            response.setError(e.getMessage());
        }

        return response;
    }


    /**
     * 分润查询
     * @param request
     * @return
     */
    @PostMapping("/getBenefitList")
    public Response getBenefitList(OrderRequest request){

        Response response = new Response();
        if(StringUtils.isBlank(request.getSubMerchantCode())){
            response.setStatus(ComCode.STATUS_CODE_4001);
            response.setMessage(ComCode.STATUS_CODE_4001_DESC);
            return response;
        }
        try {

            // 不分页
            response.setData(benefitSevice.getBenefitList(request));

            // 如果分页则调用
//            response.setData(benefitSevice.getBenefitPage(request));
            response.setStatus(ComCode.STATUS_CODE_2000);
            response.setMessage(ComCode.STATUS_CODE_2000_DESC);
            return response;
        }catch (Exception e){
            response.setStatus(ComCode.STATUS_CODE_9998);
            response.setMessage(ComCode.STATUS_CODE_9998_DESC);
            response.setError(e.getMessage());
        }

        return response;
    }
}
