package com.thinkgem.jeesite.modules.messageCenter.service;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.messageCenter.bean.ArticleRequest;
import com.thinkgem.jeesite.modules.messageCenter.dao.ArticleApiDao;
import com.thinkgem.jeesite.modules.messageCenter.entity.ArticleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.net.InetAddress;
import java.util.List;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class ArticleApiService {

    @Autowired
    private ArticleApiDao articleApiDao;

    public List<ArticleEntity> getArticles(ArticleRequest request){
        request.setPageNum(((request.getPageNum()<1?1:request.getPageNum())-1)*request.getPageSize());
        request.setPageSize(request.getPageSize());
        List<ArticleEntity> articles = articleApiDao.getArticles(request);
        for (ArticleEntity entity: articles) {
            if(!StringUtils.isBlank(entity.getImage())){
                String replace = entity.getImage().replace("/youka-manage/", "http://youkapay.com/youka-manage/");
                entity.setImage(replace);
            }
        }
        return articles;
    }

    @Transactional(readOnly = false)
    public ArticleEntity getArticleDetail(ArticleRequest request){
        ArticleEntity articleDetail = articleApiDao.getArticleDetail(request);
        if(articleDetail != null){
            articleApiDao.addNumer(request);
        }
        String content = articleDetail.getContent();
        if(content.contains("/youka-manage/")){
            String replace = content.replace("/youka-manage/", "http://youkapay.com/youka-manage/");
            articleDetail.setContent(replace);
        }
        return articleDetail;
    }
}
