package com.thinkgem.jeesite.modules.messageCenter.service;

import com.thinkgem.jeesite.modules.messageCenter.bean.ArticleRequest;
import com.thinkgem.jeesite.modules.messageCenter.dao.ArticleApiDao;
import com.thinkgem.jeesite.modules.messageCenter.entity.ArticleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class ArticleApiService {

    @Autowired
    private ArticleApiDao articleApiDao;

    public List<ArticleEntity> getArticles(ArticleRequest request) throws Exception {
        return articleApiDao.getArticles(request);
    }

    public ArticleEntity getArticleDetail(ArticleRequest request) throws Exception {
        return articleApiDao.getArticleDetail(request);
    }
}
