package com.thinkgem.jeesite.modules.pay.pinganbank.util;

import com.alibaba.fastjson.JSONObject;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class XmlUtil {
    public static JSONObject xml2JSON(byte[] xml) throws JDOMException, IOException {
        JSONObject json = new JSONObject();
        InputStream is = new ByteArrayInputStream(xml);
        SAXBuilder sb = new SAXBuilder();
        org.jdom2.Document doc = sb.build(is);
        Element root = doc.getRootElement();
        json.put(root.getName(), iterateElement(root));
        return json;
    }

    private static JSONObject iterateElement(Element element) {
        List node = element.getChildren();
        Element et = null;
        JSONObject obj = new JSONObject();
        List list = null;
        for (int i = 0; i < node.size(); i++) {
            list = new LinkedList();
            et = (Element) node.get(i);
            if (et.getTextTrim().equals("")) {
                if (et.getChildren().size() == 0)
                    continue;
                if (obj.containsKey(et.getName())) {
                    list = (List) obj.get(et.getName());
                }
                list.add(iterateElement(et));
                obj.put(et.getName(), list);
            } else {
                if (obj.containsKey(et.getName())) {
                    list = (List) obj.get(et.getName());
                }
                list.add(et.getTextTrim());
                obj.put(et.getName(), list);
            }
        }
        return obj;
    }

    /**
     * JsonObject转换成xml
     *
     * @param json
     * @return
     */
    public static String JsonBean2XmlString(JSONObject json){
        System.out.println("JsonBean转换成xml:");
        System.out.println("json:"+json);
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"GBK\"?><Result>");
        for(Object key : json.keySet()){
            sb.append("<").append(key).append(">");
            Object value = json.get(key);
            //判断value是否含有JSONArray
            try {
                JSONObject jsonV = ((JSONObject)value);
                for(Object key2 : jsonV.keySet()){
                    sb.append("<").append(key2).append(">");
                    Object value2 = jsonV.get(key2);
                    sb.append(value2);
                    sb.append("</").append(key2).append(">");
                }
            }catch (Exception e){
                sb.append(value);
            }

            sb.append("</").append(key).append(">");
        }
        sb.append("</Result>");
        return sb.toString();
    }

    public static void main(String[] args) throws JDOMException, IOException {
        String xml="<?xml version=\"1.0\" encoding=\"utf-8\" ?><MoBaoAccount MessageType=\"UserMobilePay\" PlatformID=\"b2ctest\"><OrderNo>M20150521084825</OrderNo><TradeAmt>5000.00</TradeAmt><Commission>0.5</Commission><UserID>zhuxiaolong</UserID><MerchID>zhuxiaolong1</MerchID><tradeType>0</tradeType><CustParam>123</CustParam> <NotifyUrl>http://mobaopay.com/callback.do</NotifyUrl><TradeSummary>订单</TradeSummary></MoBaoAccount>";
        JSONObject json=xml2JSON(xml.getBytes());
        System.out.println(json.toJSONString());

        System.out.println(JsonBean2XmlString(json));
    }
}
