package com.thinkgem.jeesite.modules.pay.dao;

import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.pay.entity.BenefitEntity;
import com.thinkgem.jeesite.modules.pay.entity.OrderEntity;
import com.thinkgem.jeesite.modules.pay.entity.UserRateEntity;
import com.thinkgem.jeesite.modules.user.entity.CardEntity;

import java.util.List;

@MyBatisDao
public interface PayApiDao {

    void saveOrderInfo(OrderEntity orderEntity);

    List<UserRateEntity> getCDEUsers(String[] pathIds);

    List<UserRateEntity> getSABUsers(UserRateEntity userRateEntity);

    void saveBenefitInfo(BenefitEntity benefitEntity);

    void updateOrderStatus(OrderEntity orderEntity);
    int updateOrderTradeNo(OrderEntity orderEntity);

    OrderEntity getOrder(OrderEntity orderEntity);

    // 按照条件获取分润之和
    BenefitEntity getBenefitSum(BenefitEntity benefitEntity);

    void updateBenefit(BenefitEntity benefitEntity);

    void deleteBenefit(BenefitEntity benefitEntity);

    // 查询状态为支付中的状态
    List<OrderEntity> getOrderListTimeing(OrderEntity orderEntity);



}
