/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.errors;

import com.ckfinder.connector.ConnectorServlet;
import com.ckfinder.connector.configuration.IConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorUtils {
    private static ErrorUtils errorUtils;
    private static Map<String, Map<Integer, String>> langMap;

    public String getErrorMsgByLangAndCode(String lang, int errorCode, IConfiguration conf) {
        if (lang != null && langMap.get(lang) != null) {
            return langMap.get(lang).get(errorCode);
        }
        if (langMap.get("en") != null) {
            return langMap.get("en").get(errorCode);
        }
        if (conf.isDebugMode()) {
            return "Unable to load error message";
        }
        return "";
    }

    public static ErrorUtils getInstance() {
        if (errorUtils == null) {
            errorUtils = new ErrorUtils();
        }
        return errorUtils;
    }

    private ErrorUtils() {
        List<String> allAvailLangCodes = this.getAllLangCodes();
        langMap = new HashMap<String, Map<Integer, String>>();
        for (String langCode : allAvailLangCodes) {
            langMap.put(langCode, this.getMessagesByLangCode(langCode));
        }
    }

    private List<String> getAllLangCodes() {
        return this.readJarFiles();
    }

    private List<String> readJarFiles() {
        ArrayList<String> langFiles = new ArrayList<String>();
        try {
            URL dirURL = ConnectorServlet.class.getResource("/lang/");
            if ("file".equals(dirURL.getProtocol())) {
                String path = URLDecoder.decode(dirURL.getPath(), "UTF-8");
                File f = new File(path);
                if (f.exists() && f.isDirectory()) {
                    for (File file : f.listFiles()) {
                        langFiles.add(file.getName().replaceAll(".xml", ""));
                    }
                }
            } else if ("jar".equals(dirURL.getProtocol())) {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (!this.checkJarEntry(jarEntry)) continue;
                    String name = jarEntry.getName().replaceAll("lang/", "");
                    langFiles.add(name.replaceAll(".xml", ""));
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return langFiles;
    }

    private boolean checkJarEntry(JarEntry jarEntry) {
        return Pattern.compile("lang.+\\.xml").matcher(jarEntry.getName()).matches();
    }

    private Map<Integer, String> getMessagesByLangCode(String langCode) {
        HashMap<Integer, String> langCodeMap = new HashMap<Integer, String>();
        try {
            InputStream is = ConnectorServlet.class.getResourceAsStream("/lang/" + langCode + ".xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            NodeList unkonwErrornodeList = doc.getElementsByTagName("errorUnknown");
            NodeList errorNodeList = doc.getElementsByTagName("error");
            Element unkonwErrorElem = (Element)unkonwErrornodeList.item(0);
            langCodeMap.put(1, unkonwErrorElem.getTextContent());
            for (int i = 0; i < errorNodeList.getLength(); ++i) {
                Element element = (Element)errorNodeList.item(i);
                langCodeMap.put(Integer.valueOf(element.getAttribute("number")), element.getTextContent());
            }
        }
        catch (Exception e) {
            return null;
        }
        return langCodeMap;
    }
}

