package com.thinkgem.jeesite.modules.pay.juhezhong.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.JuhezhongUtils;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.*;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.HttpUtil;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.MakeOrderNum;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.SignUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Map;

/**
 * HL4通道--https://github.com/juhezhong/quickPayDemo
 */
@Service
@Lazy(false)
@Transactional
public class JuHeZhongPayService {

/**
 * 2018/05/31
 * 快捷B接口
 *
 * @return
 */
public JSONObject quickBPay ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.QUICK_PAY , params );
    return JSONObject.parseObject ( respStr );
}

/**
 * 2018/05/31
 * 查询订单接口
 *
 * @return
 */
public JSONObject orderQuery ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.ORDER_QUERY , params );
    return JSONObject.parseObject ( respStr );
}

/**
 * 2018/05/31
 * 银联WAP快捷（借）
 *
 * @return
 */
public JSONObject quickWebPay ( JuhezhongDto dto ) throws Exception {
    Map < String, Object > params = JuhezhongUtils.juhezhongBaseDtoToMap ( dto );
    String respStr = HttpUtil.post ( ComCode.JUHEZHONG_URL + ComCode.QUICK_WEB_PAY , params );
    return JSONObject.parseObject ( respStr );
}

    /**
     * 注册子商户
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject register(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.MERCHANT_REG_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新费率
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateRate(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.RATE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新结算信息
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateSettle(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.SETTLE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 快捷支付
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject quickPay(ApiQuickPayDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }


    /**
     * 快捷支付 无积分
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject quickPay(QuickDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        System.out.println(params);
        String signBefore = SignUtils.signBefore(params);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }
    public JSONObject quickPay(JuhezhongDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        System.out.println(params);
        String signBefore = SignUtils.signBefore(params);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        System.out.println("sign2:"+sign);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }

    public JSONObject quickPay(JSONObject dto)throws Exception{
        String signBefore = SignUtils.signBefore(dto);
        System.out.println(signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        System.out.println("sign:"+sign);
        dto.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_QUICK_PAY_URL, dto);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 查询订单状态
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(ApiQuickPayDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.ORDER_QUERY_URL, params);

        return JSONObject.parseObject(respStr);
    }

    /**
     * 查询订单状态  无积分
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(CommonDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.NO_INTEGRAL_ORDER_QUERY_URL, params);
        return JSONObject.parseObject(respStr);
    }

}
