package com.thinkgem.jeesite.modules.homepage.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.homepage.bean.AdvRequest;
import com.thinkgem.jeesite.modules.homepage.service.AdvService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 轮播图
 */
@RestController
@RequestMapping("/api/home")
public class AdvController {
    @Autowired
    private AdvService advService;

    /**
     * 获取轮播图
     * @param request
     * @return
     */
    @PostMapping("/getAdvList")
    public Response getAdvList(AdvRequest request) {
        Response resp = new Response();
        try {
            resp.setData(advService.getAdvList(request));
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }

}
