package com.thinkgem.jeesite.modules.messageCenter.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.messageCenter.bean.ArticleRequest;
import com.thinkgem.jeesite.modules.messageCenter.service.ArticleApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 首页通知
 */
@RestController
@RequestMapping("/api/article")
public class ArticleApiController {
    @Autowired
    private ArticleApiService articleApiService;

    /**
     * 获取消息列表
     *
     * @param request
     * @return
     */
    @PostMapping("/getArticles")
    public Response getArticles(ArticleRequest request) {
        Response resp = new Response();
        try {
            resp.setData(articleApiService.getArticles(request));
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }

    /**
     * 获取消息详情
     *
     * @param request
     * @return
     */
    @PostMapping("/getArticleDetail")
    public Response getArticleDetail(ArticleRequest request) {
        Response resp = new Response();
        try {
            resp.setData(articleApiService.getArticleDetail(request));
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }
}
