package com.thinkgem.jeesite.modules.user.entity;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thinkgem.jeesite.common.baseBean.BaseEntity;

import java.io.Serializable;

public class UserDetailEntity extends BaseEntity implements Serializable {
    @JsonIgnore
    private String userCode; // 用户code
    private String realName; // 真实姓名
    private String idCard; // 身份证号
    private String idCardPlace; // 身份证地址
    private String idCardFront; // 身份证正面
    private String idCardBack; // 身份证反面
    private String idCardHold; // 手持身份证
    private String debitCard; // 结算卡正面
    private CardEntity card; // 结算卡信息

    public UserDetailEntity() {
    }

    public UserDetailEntity(String code, String userCode, String realName, String idCard, String idCardPlace, String idCardFront, String idCardBack, String idCardHold, String debitCard) {
        this.setCode(code);
        this.userCode = userCode;
        this.realName = realName;
        this.idCard = idCard;
        this.idCardPlace = idCardPlace;
        this.idCardFront = idCardFront;
        this.idCardBack = idCardBack;
        this.idCardHold = idCardHold;
        this.debitCard = debitCard;
        this.setCreatedUser("sys");
        this.setModifiedUser("sys");
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getIdCardPlace() {
        return idCardPlace;
    }

    public void setIdCardPlace(String idCardPlace) {
        this.idCardPlace = idCardPlace;
    }

    public String getIdCardFront() {
        return idCardFront;
    }

    public void setIdCardFront(String idCardFront) {
        this.idCardFront = idCardFront;
    }

    public String getIdCardBack() {
        return idCardBack;
    }

    public void setIdCardBack(String idCardBack) {
        this.idCardBack = idCardBack;
    }

    public String getIdCardHold() {
        return idCardHold;
    }

    public void setIdCardHold(String idCardHold) {
        this.idCardHold = idCardHold;
    }

    public String getDebitCard() {
        return debitCard;
    }

    public void setDebitCard(String debitCard) {
        this.debitCard = debitCard;
    }

    public CardEntity getCard() {
        return card;
    }

    public void setCard(CardEntity card) {
        this.card = card;
    }
}
