package com.thinkgem.jeesite.modules.pay.service;

import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.pay.dao.PayApiDao;
import com.thinkgem.jeesite.modules.pay.entity.BalanceEntity;
import com.thinkgem.jeesite.modules.pay.entity.BenefitEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DecimalFormat;
import java.util.Date;

/**
 * @author niehh
 * @Description:分润相关
 * @date 2018年03月15日 10:30
 */
@Service
@Transactional(readOnly = true)
public class BenefitSevice {
    @Autowired
    private PayApiDao payDao;

    public BalanceEntity getBalance(BenefitEntity entity){

        BalanceEntity balanceEntity = new BalanceEntity();

        // 总收益
        entity.setBenefitType("A");
        BenefitEntity benefitEntityA = payDao.getBenefitSum(entity);

        // 总提现
        entity.setBenefitType("M");
        BenefitEntity benefitEntityM = payDao.getBenefitSum(entity);

        // 余额 = 总收益-总提现
        if(benefitEntityA==null){
            balanceEntity.setBalance("0.00");
        }else {
            if(benefitEntityA.getAmount() == null){
                benefitEntityA.setAmount("0.00");
            }
            if(benefitEntityM == null){
                balanceEntity.setBalance(benefitEntityA.getAmount());
            }else{
                if(benefitEntityM.getAmount() == null ){
                    benefitEntityM.setAmount("0.00");
                }
                DecimalFormat df = new DecimalFormat("######0.00");
                balanceEntity.setBalance(df.format(Double.valueOf(benefitEntityA.getAmount()) - Double.valueOf(benefitEntityM.getAmount())));
            }
        }

        // 今日收益
        entity.setBenefitType("A");
        Date date = new Date();
        String today = DateUtils.formatDate(date,"yyyy-MM-dd HH:mm:ss");
        entity.setEndTime(today);
        entity.setStartTime(DateUtils.formatDate(date,"yyyy-MM-dd") + " 00:00:00");
        BenefitEntity benefitEntityToday = payDao.getBenefitSum(entity);
        if(benefitEntityToday != null && StringUtils.isNotBlank(benefitEntityToday.getAmount())){
            balanceEntity.setTodayIncome(benefitEntityToday.getAmount());
        }else{
            balanceEntity.setTodayIncome("0.00");
        }

        // 昨日收益
//        entity.setEndTime(DateUtils.);
        entity.setEndTime(DateUtils.formatDate(date,"yyyy-MM-dd") + " 00:00:00");


        return balanceEntity;
    }
}
