package com.thinkgem.jeesite.modules.homepage.service;

import com.thinkgem.jeesite.modules.homepage.bean.NoticeRequest;
import com.thinkgem.jeesite.modules.homepage.dao.NoticeDao;
import com.thinkgem.jeesite.modules.homepage.entity.NoticeEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class NoticeService {

    @Autowired
    private NoticeDao noticeDao;

    public List<NoticeEntity> getNotice(NoticeRequest request) throws Exception {
        return noticeDao.getNotice(request);
    }
}
