package com.thinkgem.jeesite.modules.pay.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.pay.entity.OrderEntity;
import com.thinkgem.jeesite.modules.pay.service.PayApiService;
import com.thinkgem.jeesite.modules.user.bean.JuHeZhongPayRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

/**
 * 支付相关
 */
@RestController
@RequestMapping("/api/pay")
public class PayApiController {
    @Autowired
    private PayApiService payService;

    /**
     * 快捷支付
     *
     * @param request
     * @return
     */
    @PostMapping("/quickPay")
    public Response quickPay(JuHeZhongPayRequest request) {
        Response resp = new Response();
        try {
            payService.quickPay(request);
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }


    @RequestMapping("/notifyPay")
    public Response notifyPay(HttpServletRequest request, HttpServletResponse response) {
        Response responseRetrun = new Response();
        //设置编码
        try {
            request.setCharacterEncoding("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            responseRetrun.setMessage("设置编码异常");
            responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
            return responseRetrun;
        }
        String orderId=request.getParameter("orderId");

        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setPayNo(orderId);

        try {
            orderEntity = payService.notifyPay(orderEntity);
        } catch (Exception e) {
            e.printStackTrace();
            responseRetrun.setMessage("回调异常");
            responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
            return responseRetrun;
        }
        //返回true 收到请求，停止通知
        PrintWriter write= null;
        try {
            write = response.getWriter();
        } catch (IOException e) {
            e.printStackTrace();
            responseRetrun.setMessage("输出异常");
            responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
            return responseRetrun;
        }
        write.print("true");
        write.flush();
        write.close();
        responseRetrun.setMessage("ok");
        responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
        responseRetrun.setData(orderEntity);
        return responseRetrun;

    }

}
