/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import java.io.File;
import org.w3c.dom.Element;

public class DeleteFolderCommand
extends XMLCommand
implements IPostCommand {
    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
    }

    protected int getDataForXml() {
        if (!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 8)) {
            return 103;
        }
        if (this.currentFolder.equals("/")) {
            return 109;
        }
        if (FileUtils.checkIfDirIsHidden(this.currentFolder, this.configuration)) {
            return 109;
        }
        File dir = new File(this.configuration.getTypes().get(this.type).getPath() + this.currentFolder);
        try {
            if (!dir.exists() || !dir.isDirectory()) {
                return 116;
            }
            if (!FileUtils.delete(dir)) {
                return 104;
            }
            File thumbDir = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder);
            FileUtils.delete(thumbDir);
        }
        catch (SecurityException e) {
            if (this.configuration.isDebugMode()) {
                throw e;
            }
            return 104;
        }
        return 0;
    }
}

