/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import java.util.Stack;
import java.util.TreeSet;
import org.wltea.analyzer.core.AnalyzeContext;
import org.wltea.analyzer.core.Lexeme;
import org.wltea.analyzer.core.LexemePath;
import org.wltea.analyzer.core.QuickSortSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IKArbitrator {
    IKArbitrator() {
    }

    void process(AnalyzeContext context, boolean useSmart) {
        LexemePath judgeResult;
        QuickSortSet.Cell headCell;
        QuickSortSet orgLexemes = context.getOrgLexemes();
        Lexeme orgLexeme = orgLexemes.pollFirst();
        LexemePath crossPath = new LexemePath();
        while (orgLexeme != null) {
            if (!crossPath.addCrossLexeme(orgLexeme)) {
                if (crossPath.size() == 1 || !useSmart) {
                    context.addLexemePath(crossPath);
                } else {
                    headCell = crossPath.getHead();
                    judgeResult = this.judge(headCell, crossPath.getPathLength());
                    context.addLexemePath(judgeResult);
                }
                crossPath = new LexemePath();
                crossPath.addCrossLexeme(orgLexeme);
            }
            orgLexeme = orgLexemes.pollFirst();
        }
        if (crossPath.size() == 1 || !useSmart) {
            context.addLexemePath(crossPath);
        } else {
            headCell = crossPath.getHead();
            judgeResult = this.judge(headCell, crossPath.getPathLength());
            context.addLexemePath(judgeResult);
        }
    }

    private LexemePath judge(QuickSortSet.Cell lexemeCell, int fullTextLength) {
        TreeSet<LexemePath> pathOptions = new TreeSet<LexemePath>();
        LexemePath option = new LexemePath();
        Stack<QuickSortSet.Cell> lexemeStack = this.forwardPath(lexemeCell, option);
        pathOptions.add(option.copy());
        QuickSortSet.Cell c = null;
        while (!lexemeStack.isEmpty()) {
            c = lexemeStack.pop();
            this.backPath(c.getLexeme(), option);
            this.forwardPath(c, option);
            pathOptions.add(option.copy());
        }
        return (LexemePath)pathOptions.first();
    }

    private Stack<QuickSortSet.Cell> forwardPath(QuickSortSet.Cell lexemeCell, LexemePath option) {
        Stack<QuickSortSet.Cell> conflictStack = new Stack<QuickSortSet.Cell>();
        QuickSortSet.Cell c = lexemeCell;
        while (c != null && c.getLexeme() != null) {
            if (!option.addNotCrossLexeme(c.getLexeme())) {
                conflictStack.push(c);
            }
            c = c.getNext();
        }
        return conflictStack;
    }

    private void backPath(Lexeme l, LexemePath option) {
        while (option.checkCross(l)) {
            option.removeTail();
        }
    }
}

