package com.thinkgem.jeesite.modules.user.dao;

import com.thinkgem.jeesite.common.baseBean.Request;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.user.bean.UserRequest;
import com.thinkgem.jeesite.modules.user.entity.*;

import java.util.List;

@MyBatisDao
public interface UserApiDao {

    UserEntity getUserInfo(Request request);

    void saveIdentifyCode(IdentityCodeEntity identityCodeEntity);

    IdentityCodeEntity getIdentifyCode(UserRequest request);

    UserEntity checkRecommend(UserRequest request);

    UserEntity checkMobile(UserRequest request);

    void signUp(UserEntity userEntity);

    void resetPassword(UserEntity request);

    UserEntity getUserInfoByPassword(UserRequest request);

    UserDetailEntity getUserDetailByCode(UserEntity code);

    CardEntity getCardInfoByCode(UserEntity userEntity);

    List<CardEntity> getCardsInfo(UserRequest request);

    void removeCards(UserRequest request);

    void addNewCard(CardEntity cardEntity);

    void addFeedback(FeedbackEntity feedbackEntity);

    AboutUsEntity getAboutUsInfo(UserRequest request);

    void saveUserDetail(UserDetailEntity userDetailEntity);

    void updateUserInfo(UserEntity userEntity);
}
