/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;

public class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] javaChars;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:39:36_PST_2008";

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n) {
        this(dBConversion, inputStream, n, 1);
    }

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n, short s) {
        super(4096);
        this.istream = inputStream;
        this.conversion = n;
        this.converter = dBConversion;
        this.maxSize = 0;
        this.totalSize = 0;
        this.numUnconvertedBytes = 0;
        this.endOfStream = false;
        this.nbytes = new int[1];
        this.csform = s;
        switch (n) {
            case 0: {
                this.javaChars = new char[4096];
                this.convbuf = new byte[4096];
                break;
            }
            case 1: {
                this.convbuf = new byte[2048];
                this.javaChars = new char[2048];
                break;
            }
            case 2: {
                this.convbuf = new byte[2048];
                this.javaChars = new char[4096];
                break;
            }
            case 3: {
                this.convbuf = new byte[1024];
                this.javaChars = new char[2048];
                break;
            }
            case 4: {
                int n2 = 4096 / this.converter.getMaxCharbyteSize();
                this.convbuf = new byte[n2 * 2];
                this.javaChars = new char[n2];
                break;
            }
            case 5: {
                if (this.converter.isUcs2CharSet()) {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[2048];
                    break;
                }
                this.convbuf = new byte[4096];
                this.javaChars = new char[4096];
                break;
            }
            case 7: {
                int n3 = 4096 / (s == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                this.javaChars = new char[n3];
                break;
            }
            default: {
                this.convbuf = new byte[4096];
                this.javaChars = new char[4096];
            }
        }
    }

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n, int n2) {
        this(dBConversion, inputStream, n, 1);
        this.maxSize = n2;
        this.totalSize = 0;
    }

    public OracleConversionInputStream(DBConversion dBConversion, Reader reader, int n, int n2, short s) {
        this(dBConversion, (InputStream)null, n, s);
        this.reader = reader;
        this.maxSize = n2;
        this.totalSize = 0;
    }

    public void setFormOfUse(short s) {
        this.csform = s;
    }

    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos < this.count) {
            return true;
        }
        if (this.istream != null) {
            return this.needBytesFromStream();
        }
        if (this.reader != null) {
            return this.needBytesFromReader();
        }
        return false;
    }

    public boolean needBytesFromReader() throws IOException {
        try {
            int n = 0;
            n = this.maxSize == 0 ? this.javaChars.length : Math.min(this.maxSize - this.totalSize, this.javaChars.length);
            if (n <= 0) {
                this.reader.close();
                this.close();
                return false;
            }
            int n2 = this.reader.read(this.javaChars, 0, n);
            if (n2 == -1) {
                this.reader.close();
                this.close();
                return false;
            }
            this.totalSize += n2;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, n2, this.buf);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n2, this.buf);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.buf, 0, n2);
                    this.count = n2;
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        this.pos = 0;
        return true;
    }

    public boolean needBytesFromStream() throws IOException {
        if (!this.endOfStream) {
            try {
                int n = 0;
                n = this.maxSize == 0 ? this.convbuf.length : Math.min(this.maxSize - this.totalSize, this.convbuf.length);
                int n2 = 0;
                if (n <= 0) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DatabaseError.throwSqlException(55);
                    }
                } else {
                    n2 = this.istream.read(this.convbuf, this.numUnconvertedBytes, n - this.numUnconvertedBytes);
                }
                if (n2 == -1) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DatabaseError.throwSqlException(55);
                    }
                } else {
                    this.totalSize += (n2 += this.numUnconvertedBytes);
                }
                if (n2 <= 0) {
                    return false;
                }
                switch (this.conversion) {
                    case 0: {
                        this.nbytes[0] = n2;
                        int n3 = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i = 0; i < this.numUnconvertedBytes; ++i) {
                            this.convbuf[i] = this.convbuf[n2 - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, n3, this.buf);
                        break;
                    }
                    case 1: {
                        this.nbytes[0] = n2;
                        int n4 = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i = 0; i < this.numUnconvertedBytes; ++i) {
                            this.convbuf[i] = this.convbuf[n2 - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, n4, this.buf);
                        break;
                    }
                    case 2: {
                        int n5 = DBConversion.RAWBytesToHexChars(this.convbuf, n2, this.javaChars);
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, n5, this.buf);
                        break;
                    }
                    case 3: {
                        int n6 = DBConversion.RAWBytesToHexChars(this.convbuf, n2, this.javaChars);
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, n6, this.buf);
                        break;
                    }
                    case 4: {
                        int n7 = DBConversion.ucs2BytesToJavaChars(this.convbuf, n2, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n7, this.buf);
                        break;
                    }
                    case 5: {
                        DBConversion.asciiBytesToJavaChars(this.convbuf, n2, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n2, this.buf);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, this.buf, 0, n2);
                        this.count = n2;
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
            this.pos = 0;
            return true;
        }
        return false;
    }
}

