package com.thinkgem.jeesite.modules.user.dao;

import com.thinkgem.jeesite.common.baseBean.Request;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.pay.entity.RateEntity;
import com.thinkgem.jeesite.modules.user.bean.UserRequest;
import com.thinkgem.jeesite.modules.user.entity.*;

import java.util.List;

@MyBatisDao
public interface UserApiDao {

    UserEntity getUserInfo(Request request);

    void saveIdentifyCode(IdentityCodeEntity identityCodeEntity);

    IdentityCodeEntity getIdentifyCode(UserRequest request);

    UserEntity checkRecommend(UserRequest request);

    UserEntity checkMobile(UserRequest request);

    void signUp(UserEntity userEntity);

    void resetPassword(UserEntity request);

    UserEntity getUserInfoByPassword(UserRequest request);

    UserDetailEntity getUserDetailByCode(UserEntity userEntity);

    CardEntity getCardInfoByCode(UserEntity userEntity);

    CardEntity getDebitCardByUserCode(UserRequest request);

    List<CardEntity> getCardsInfo(UserRequest request);

    CardEntity getCardInfo(Request request);

    void removeCards(UserRequest request);

    void updateCardStatus(CardEntity cardStatusEntity);

    void addNewCard(CardEntity cardEntity);

    void addFeedback(FeedbackEntity feedbackEntity);

    AboutUsEntity getAboutUsInfo(UserRequest request);

    void saveUserDetail(UserDetailEntity userDetailEntity);

    void updateUserDetail(UserDetailEntity userDetailEntity);

    void updateUserInfo(UserEntity userEntity);

    void updateUser(UserRequest userRequest);

    RateEntity getRateByLevel(RateEntity rateEntityParam);

    List<RateEntity> getRateListByLevel(RateEntity rateEntityParam);

    List<UserEntity> getUserInfoBySameRecommend(UserEntity queryUserRecommendEntity);

    UserEntity getUserInfoById(String userId);

    void updateUserLevel(UserEntity recommendedUser);

    void updateUserLevelByCode(UserEntity recommendedUser);

    List<CardEntity> getRecommendCardsInfo(UserEntity recommendedUser);

    void updateCardNoDebit(UserRequest request);

    void updateCardDebit(UserRequest request);

    CardEntity getDebitCard(CardEntity cardEntity);

    List<ProvinceCityEntity> getProvince(UserRequest request);

    List<ProvinceCityEntity> getCity(UserRequest request);

    List<BelongBankEntity> getBelongBank(UserRequest request);

    List<BelongBankEntity> getBelongBankByPayChannel(UserRequest request);

    BelongBankEntity getBelongBankEntity(UserRequest request);

    Level getLevelByUserLevel(UserRequest request);

    void addUserSubmchid(UserSubMchId userSubMchId);

    UserSubMchId getUserSubmchid(UserSubMchId userSubMchId);

    public int updateUserSubmchid(UserSubMchId userSubMchId);



    public CardEntity getCardByCardNo(CardEntity cardEntity);

    public int addSwpaccid(CardSwpaccidEntity entity);

    public CardSwpaccidEntity getSwpaccid(CardSwpaccidEntity cardSwpaccidEntity);

    CardEntity getCardInfoSwpaccid(Request request);


    // 添加 待升级王者的用户记录表
    public Integer addUpgradeUser(UpgradeUserEntity entity);

    // 更新 待升级王者的用户记录表
    public Integer updateUpgradeUser(UpgradeUserEntity entity);
    //获取邀请好友
    List<UserEntity> getMyInviting(UserRequest request);
    //激活用户数量
    public Integer getActiveUserNum(UserRequest request);

    public Integer checkNoUser();

    //修改银行卡信息
    void updateCard(CardEntity cardEntity);

    CardEntity getCardEntity(Request request);

    //获取所有级别是青铜,推荐数大于等于3的推荐人
    List<UserEntity> getUserLevelIsE();

    //获取满足条件的数量
    Integer getMatchNum(String mobile);

    //获取用户升级之前信息
    UserEntity getUpgradeUserInfo(String mobile);

    //获取等级升级条件
    List<LevelDetail> getLevelDetail();

    LevelDetail getLevelDetailByLevel(UserRequest request);
}
