package com.thinkgem.jeesite.modules.pay.pinganbank.util;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jdom2.JDOMException;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class PingAnBankUtils {

    public static String getBobyLength(String boby) throws UnsupportedEncodingException {
        String length = boby.getBytes("GBK").length+"";
        int sub = 10-length.length() ;

        StringBuffer sb = new StringBuffer();
        for(int i=0;i<sub;i++){
            sb.append("0");
        }
        sb.append(length);

        return sb.toString();
    }

    public static String getHead(String boby,String enterprisecode,String transactionCode,String orderCode) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();

        sb.append("A001010102")
                .append(enterprisecode)
                .append(PingAnBankUtils.getBobyLength(boby))
                .append(transactionCode)
                .append("  ")
                .append("0000001")
                .append(DateUtils.formatDate(new Date(),"yyyymmddhhmmss"));// 时间
        if(StringUtils.isBlank(orderCode)){
            orderCode = IdGen.randomBase62(20);
        }
        sb.append(orderCode)// 交易码
                .append("000000")//返回码 请求时必须填写 000000 非“000000”代表交易受理异常或失败
                .append("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000RSA-SHA100000000000")
                .append(boby.toString());
        System.out.println(sb.toString());

        return sb.toString();
    }

    public static JSONObject post(String parma) throws IOException, JDOMException {

        // 目前是本地的服务 等服务器好了之后
        PostMethod postMethod = new PostMethod(
                ComCode.PINGANBANK_B2BICURL);

        postMethod.setRequestEntity(new StringRequestEntity(
                parma, "text/html", "GBK"));
        postMethod.setRequestHeader("Content-Type",
                "text/xml; charset=GBK");

        HttpClient httpClient = new HttpClient();
        int resultint = httpClient.executeMethod(postMethod);
        System.out.println(postMethod.getResponseBody());
        String res = new String(postMethod.getResponseBody(),"GBK");
        System.out.println("http response:" + res);
        postMethod.releaseConnection();
        System.out.println(resultint);
        if(res.contains("<")){
            System.out.println(res.substring(res.indexOf("<")));
            JSONObject json= XmlUtil.xml2JSON(res.substring(res.indexOf("<")).getBytes());
            System.out.println(json.toJSONString());
            return json;
        }
       JSONObject jsonObject = new JSONObject();
        jsonObject.put("all",res);
        return jsonObject;

    }
}
