package com.thinkgem.jeesite.modules.pay.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.pay.entity.OrderEntity;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.PayBackDto;
import com.thinkgem.jeesite.modules.pay.service.PayApiService;
import com.thinkgem.jeesite.modules.user.bean.JuHeZhongPayRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * 支付相关
 */
@RestController
@RequestMapping("/api/pay")
public class PayApiController {
    @Autowired
    private PayApiService payService;

    /**
     * 快捷支付
     *
     * @param request
     * @return
     */
    @PostMapping("/quickPay")
    public Response quickPay(JuHeZhongPayRequest request) {
        Response resp = new Response();
        try {
            PayBackDto payBackDto = payService.quickPay(request);
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
            resp.setData(payBackDto);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }


    /**
     * 回调
     * @param request
     * @param response
     */
    @RequestMapping("/notifyPay")
    public void notifyPay(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("。。。。。。回调。。。。。");
        Response responseRetrun = new Response();
        Map map=request.getParameterMap();
        Set keSet=map.entrySet();
        for(Iterator itr = keSet.iterator(); itr.hasNext();){
            Map.Entry me=(Map.Entry)itr.next();
            Object ok=me.getKey(); //获取参数名
            Object ov=me.getValue(); //获取参数值
            System.out.println(ok+"="+ok.toString());
            System.out.println(ov+"="+ov.toString());
            String[] value=new String[1];
            if(ov instanceof String[]){
                value=(String[])ov;
            }else{
                value[0]=ov.toString();
            }
            for(int k=0;k <value.length;k++){
                System.out.println(ok+"="+value[k]);
            }
        }
        //设置编码
        try {
            request.setCharacterEncoding("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();

        }
        String orderId=request.getParameter("orderId");
        String code = request.getParameter("code");
        if("0000".equals(code)){
            System.out.println("orderId:"+orderId);
            OrderEntity orderEntity = new OrderEntity();

            orderEntity.setPayCode(orderId);

            try {
                orderEntity = payService.notifyPay(orderEntity);
            } catch (Exception e) {
                e.printStackTrace();

            }
            //返回true 收到请求，停止通知
            PrintWriter write= null;
            try {
                write = response.getWriter();
            } catch (IOException e) {
                e.printStackTrace();
            }
            write.print("true");

            responseRetrun.setMessage("ok");
            responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
            responseRetrun.setData(orderEntity);
            write.flush();
            write.close();
        }


    }


    /**
     * 获取支付的结果
     * @param orderEntity
     * @return
     */
    @RequestMapping("/payDetail")
    public Response payDetail(OrderEntity orderEntity) {

        Response responseRetrun = new Response();


        try {
            // 获取订单
            orderEntity = payService.getOrder(orderEntity);
            if(orderEntity == null){
                responseRetrun.setMessage(ComCode.STATUS_CODE_6001_DESC);
                responseRetrun.setStatus(ComCode.STATUS_CODE_6001);
                return responseRetrun;
            }

            // 已经支付成功或者支付失败的直接返回结果
            if("2".equals(orderEntity.getPayStatus()) || "3".equals(orderEntity.getPayStatus()) || "4".equals(orderEntity.getPayStatus())){
                responseRetrun.setMessage("ok");
                responseRetrun.setStatus(ComCode.STATUS_CODE_2000);
                responseRetrun.setData(orderEntity);

                return responseRetrun;
            }

            // 未经过回调的 先进行juhezhong支付状态查询
            orderEntity = payService.notifyPay(orderEntity);
        } catch (Exception e) {
            e.printStackTrace();
            responseRetrun.setMessage(ComCode.STATUS_CODE_9998_DESC);
            responseRetrun.setStatus(ComCode.STATUS_CODE_9998);
            return responseRetrun;
        }
        responseRetrun.setMessage("ok");
        responseRetrun.setStatus(ComCode.STATUS_CODE_2000);
        responseRetrun.setData(orderEntity);

        return responseRetrun;

    }

}
