package com.thinkgem.jeesite.modules.homepage.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.homepage.bean.AdvRequest;
import com.thinkgem.jeesite.modules.homepage.service.AdvService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 验证失败返回
 */
@RestController
@RequestMapping("/api/home")
public class AdvController {
    @Autowired
    private AdvService advService;

    @PostMapping("/getAdvList")
    public Response getAdvList(AdvRequest request) {
        Response resp = new Response();
        resp.setData(advService.getAdvList(request));
        resp.setStatus(ComCode.STATUS_CODE_2000);
        resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        return resp;
    }

}
