package com.thinkgem.jeesite.modules.homepage.service;

import com.thinkgem.jeesite.modules.homepage.bean.AdvRequest;
import com.thinkgem.jeesite.modules.homepage.dao.AdvDao;
import com.thinkgem.jeesite.modules.homepage.entity.AdvEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 轮播图
 */
@Service
@Transactional(readOnly = true)
public class AdvService {

    @Autowired
    private AdvDao advDao;

    public List<AdvEntity> getAdvList(AdvRequest request) throws Exception {
        List<AdvEntity> advList = advDao.getAdvList(request);
        for (AdvEntity entity : advList){
           String content = entity.getPicture();
            if(content.contains("/youka-manage/")){
                String replace = content.replace("/youka-manage/", "http://youkapay.com/youka-manage/");
                entity.setPicture(replace);
            }
        }
        return advList;
    }
}
