<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>消息中心</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#read").click(function () {
                top.$.jBox.confirm("确认要全部设为已读吗？","系统提示",function(v,h,f){
                    if(v=="ok"){
                        var idArray= $("#idArray").val();
                        if(idArray != null && idArray != ""){
                            window.location.href = "${ctx}/notice/read?idArray="+idArray;
                        }else {
                            //弹窗
                            top.$.jBox.tip("所有数据已读，请勿重复操作","系统提示",null,null);
                        }
                    }
                },{buttonsFocus:1});
                top.$('.jbox-body .jbox-icon').css('top','55px');
            });
            $("#refresh").click(function () {
                window.location.href = "${ctx}/notice/list";
            });
            //序号连续
            var i = 1;
            var pageNo = $("#pageNo").val();
            var pageSize = $("#pageSize").val();
            $(".reportList").each(function(){
                var num = (pageNo-1)*pageSize + i;
                i += 1;
                $(this).children("td:first-child").html(num);
            });
        });
        function page(n,s){
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/notice/list");
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
    <ul class="nav nav-tabs">
        <li style="float: right;"><input id="refresh" class="btn btn-primary" type="button" value="刷新"/></li>
        <li style="float: right;"><label>&nbsp;&nbsp;</label></li>
        <li style="float: right;"><input id="read" class="btn btn-primary" type="button" value="全部设为已读"/></li>
    </ul>
    <form:form id="searchForm" modelAttribute="" action="" method="post" class="breadcrumb form-search">
        <input id="pageNo" name="pageNo" type="hidden" value="${noticePage.pageNo}"/>
        <input id="pageSize" name="pageSize" type="hidden" value="${noticePage.pageSize}"/>
        <input id="idArray" name="" type="hidden" value="${idArray}"/>
    </form:form>
    <sys:message content="${message}"/>
    <table id="contentTable" class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
                <th>ID</th>
                <th>标题</th>
                <th>发送时间</th>
                <th>发送人</th>
                <th>状态</th>
            </tr>
        </thead>
        <tbody>
        <c:if test="${noticePage.list.size()>0}">
            <c:forEach items="${noticePage.list}" var="notice" varStatus="vs">
                <tr class="reportList">
                    <td></td>
                    <td><a href="${ctx}/notice/view?id=${notice.id}&reportId=${notice.reportId}"><span <c:if test="${notice.status eq '1'}">style="color: #6f4086"</c:if>>${notice.title}。</span></a></td>
                    <td>${notice.sendTime}</td>
                    <td>${notice.sendFromName}</td>
                    <td>
                        <c:if test="${notice.status eq '0'}">未读</c:if>
                        <c:if test="${notice.status eq '1'}">已读</c:if>
                    </td>
                </tr>
            </c:forEach>
        </c:if>
        </tbody>
    </table>
    <c:if test="${noticePage.list == null}">
        <span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
    </c:if>
    <c:if test="${noticePage.list.size()>0}">
        <div class="pagination">${noticePage}</div>
    </c:if>
</body>
</html>