<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>举报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            //弹出隐藏层
            $("#btnDistribute").click(function () {
                $("#chooseDiv").show();
                $("#fade").show();
                $("#fade").style.width = document.body.scrollWidth;
                $("#fade").height($(document).height());
            });
            //关闭隐藏层
            $("#btnClose").click(function () {
                $("#chooseDiv").hide();
                $("#fade").hide();
            });
            //选中用户并关闭
            $("#btnConfirm").click(function () {
                var reportIds = new Array();
                $("input:checkbox:checked").each(function(){
                    reportIds.push($(this).val());
                });
                var userId = $("input:radio:checked").val();
                $.ajax({
                    url: "${ctx}/report/deliver",
                    dataType: "json",
                    data: {
                        "reportIds":reportIds,
                        "userId":userId
                    },
                    traditional: true,//这里设置为true
                    cache: false,
                    success: function(result) { //登录成功后返回的数据
                        if (result == "1"){
                            $("#searchForm").submit();
                        }
                    },
                    error:function(){
                        alert("请选择需要移交的数据！");
                    }
                });
                $("#chooseDiv").hide();
                $("#fade").hide();
            });
            //序号连续
            var i = 1;
            var pageNo = $("#pageNo").val();
            var pageSize = $("#pageSize").val();
            $(".reportList").each(function(){
                var num = (pageNo-1)*pageSize + i;
                i += 1;
                $(this).children("td").eq(1).html(num);
            });
        });
        function resetPageNo() {
            $("#pageNo").val(0);
        }
    </script>
    <style type="text/css">
        .black_overlay{
            display: none;
            position: absolute;
            top: 0%;
            left: 0%;
            width: 100%;
            height: 100%;
            z-index:1001;
            -moz-opacity: 0.8;
            opacity:.80;
            filter: alpha(opacity=80);
        }
        .white_content {
            display: none;
            position: absolute;
            top: 10%;
            left: 10%;
            width: 80%;
            height: 80%;
            border: 1px solid;
            background-color: white;
            z-index:1002;
            overflow: auto;
        }
        #chooseContent{
            margin: 20px 20px 20px 20px;
        }
    </style>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/report/deliverList">工作转交</a></li>
</ul>
<form:form id="searchForm" modelAttribute="report" action="${ctx}/report/deliverList" method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>处理人：</label><form:input  onchange="resetPageNo();"  path="dealPersonName" htmlEscape="false" maxlength="50" class="input-small"/></li>
        <li class="btns">
            <label style="width:auto;"><input id="btnSubmit" class="btn btn-primary" type="submit" value="筛选"/>&nbsp;&nbsp;</label>
        </li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<li class="btns">
    <label style="width:auto;"><input id="btnDistribute" class="btn btn-primary" type="button" value="分配"/>&nbsp;&nbsp;</label>
</li>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>选择</th>
        <th>ID</th>
        <th>标题</th>
        <th >所属集团</th>
        <th >所属区域</th>
        <th >业务类型</th>
        <th >业务类别</th>
        <th>被举报项目/部门</th>
        <th>举报人</th>
        <th>举报人电话</th>
        <th>被举报人</th>
        <th>举报时间</th>
        <th>状态</th>
        <th>处理结论</th>
        <th>处理人</th>
        <th>转交给</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:if test="${page.list.size()>0}">
        <c:forEach items="${page.list}" var="report" varStatus="vs">
            <tr class="reportList">
                <td><input type="checkbox" value="${report.id}"></td>
                <td></td>
                <td>${report.supplementTitle}</td>
                <td align="center">
                        ${report.supplementGroup}
                  <%--  <c:if test="${user.supplementGroup eq '30590306011301372591'}">集团本部</c:if>
                    <c:if test="${user.supplementGroup eq '30676650749523023279'}">地产集团</c:if>
                    <c:if test="${user.supplementGroup eq '30721878435509835919'}">服务集团</c:if>
                    <c:if test="${user.supplementGroup eq '30795782242187242020'}">文化集团</c:if>
                    <c:if test="${user.supplementGroup eq '30770202834994792595'}">文旅集团</c:if>--%>
                </td>
                <td align="center">${report.supplementArea}</td>
                <td align="center">${report.supplementType}</td>
                <td align="center">${report.supplementCategory}</td>

                <td>${report.reportProject}/${report.supplementDepartment}</td>
                <td>${report.reportPersonName}</td>
                <td>${report.reportPersonTel}</td>
                <td>
                    <c:if test="${report.supplementInformant eq null}">--</c:if>
                    <c:if test="${report.supplementInformant ne null}">${report.supplementInformant}</c:if>
                </td>
                <td>${report.reportTime}</td>
                <td>
                    <c:if test="${report.reportStatus eq '0'}">未处理</c:if>
                    <c:if test="${report.reportStatus eq '1'}">跟踪中</c:if>
                    <c:if test="${report.reportStatus eq '2'}">已处理</c:if>
                    <c:if test="${report.reportStatus eq '3'}">已关闭</c:if>
                </td>
                <td>
                    <c:if test="${report.dealResult eq null}">--</c:if>
                    <c:if test="${report.dealResult eq '1'}">移交客诉</c:if>
                    <c:if test="${report.dealResult eq '2'}">举报无效</c:if>
                    <c:if test="${report.dealResult eq '3'}">举报受理</c:if>
                    <c:if test="${report.dealResult eq '4'}">举报属实</c:if>
                    <c:if test="${report.dealResult eq '5'}">举报不实</c:if>
                    <c:if test="${report.dealResult eq '6'}">移交其他部门</c:if>
                </td>
                <td><c:if test="${report.dealPersonName eq null}">--</c:if>
                    <c:if test="${report.dealPersonName ne null}">${report.dealPersonName}</c:if>
                </td>
                <td>
                    <c:if test="${report.transferName eq null || report.exchangeType eq null}">--</c:if>
                    <c:if test="${report.transferName ne null && report.exchangeType ne null}">${report.transferName}</c:if>
                </td>
                <td>
                    <a href="${ctx}/report/view?id=${report.id}">查看</a>
                </td>
            </tr>
        </c:forEach>
    </c:if>
    </tbody>
</table>
<c:if test="${page.list.size()=='0'}">
    <span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
</c:if>
<c:if test="${page.list.size()>0}">
    <div class="pagination">${page}</div>
</c:if>
<div id="fade" class="black_overlay"></div>
<div id="chooseDiv" class="white_content">
    <div id="chooseContent">
        <script type="text/javascript">
            $(document).ready(function() {
                $("#btnSearch").click(function () {
                    $.ajax({
                        url: "${ctx}/report/viewTransfer?flag=2",
                        dataType: "html",
                        data: $('#searchForm1').serialize(),
                        cache: false,
                        beforeSend: function () {
                            // 禁用按钮防止重复提交
                            $("#btnSearch").attr({ disabled: "disabled" });
                        },
                        success: function(data) { //登录成功后返回的数据
                            $("#userList").empty();
                            $("#userList").html($(data));
                        },
                        error:function(){
                            alert("数据错误！");
                        },
                        complete: function () {
                            $("#btnSearch").removeAttr("disabled");
                        }
                    });
                });
                $("input:radio").click(function () {
                    $("input:radio").attr("checked",false);
                    $("#chooseItem").empty();
                    $(this).attr("checked",true);
                    $("#chooseItem").html("已选择 " + $("input:radio:checked").parent().next().next().next().html()+"<span onclick='remove();'><font size='5'> ×</font></span>");
                });
            });
            function chooseRen(obj) {
                $("input:radio").attr("checked",false);
                $("#chooseItem").empty();
                obj.checked = true;
                $("#chooseItem").html("已选择 " + $("input:radio:checked").parent().next().next().next().html()+"<span onclick='remove();'><font size='5'> ×</font></span>");
            }
            function remove(){
                $("input:radio").attr("checked",false);
                $("#chooseItem").empty();
            }
            function page(n,s,l){
                if (l == "1"){
                    $("#userPageNo").val(n);
                    $("#userPageSize").val(s);
                    $.ajax({
                        url: "${ctx}/report/viewTransfer?flag=2",
                        dataType: "html",
                        data: $('#searchForm1').serialize(),
                        cache: false,
                        success: function(data) { //登录成功后返回的数据
                            $("#userList").empty();
                            $("#userList").html($(data));
                        },
                        error:function(){
                            alert("数据错误！");
                        }
                    });
                    return false;
                }else {
                    $("#pageNo").val(n);
                    $("#pageSize").val(s);
                    $("#searchForm").attr("action", "${ctx}/report/deliverList");
                    $("#searchForm").submit();
                    return false;
                }
            }
            function resetUserPageNo() {
                $("#pageNo").val(0);
            }
        </script>
        <span class="title">选择移交人员</span>
        <form:form id="searchForm1" modelAttribute="user" action="#" method="post" class="breadcrumb form-search">
            <input id="userPageNo" name="pageNo" type="hidden" value="${userPage.pageNo}"/>
            <input id="userPageSize" name="pageSize" type="hidden" value="${userPage.pageSize}"/>
            <ul class="ul-form">
                <li><label>用户名：</label><form:input  onchange="resetUserPageNo();"  path="loginName" htmlEscape="false" maxlength="50" class="input-small"/></li>
                <li><label>姓名：</label><form:input  onchange="resetUserPageNo();"  path="name" htmlEscape="false" maxlength="50" class="input-small"/></li>
                <li><label>手机号码：</label><form:input  onchange="resetUserPageNo();"  path="mobile" htmlEscape="false" maxlength="50" class="input-small"/></li>
                <li class="btns">
                    <label style="width:auto;"><input id="btnSearch" class="btn btn-primary" type="button" value="筛选"/>&nbsp;&nbsp;</label>
                </li>
                <li class="clearfix"></li>
            </ul>
        </form:form>
        <div id="userList">
            <table id="contentTable" class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th>选择</th>
                    <th>ID</th>
                    <th>用户名</th>
                    <th>姓名</th>
                    <th>组织</th>
                    <th>手机号码</th>
                    <th>角色</th>
                </tr>
                </thead>
                <tbody>

                <c:if test="${userPage.list.size()>0}">
                    <c:forEach items="${userPage.list}" var="user" varStatus="vs">
                        <tr>
                            <td id="radioBtn"><input type="radio" value="${user.id}"></td>
                            <td>${vs.count}</td>
                            <td>${user.loginName}</td>
                            <td>${user.name}</td>
                            <td>${user.devision}</td>
                            <td>${user.mobile}</td>
                            <td>${user.role.name}</td>
                        </tr>
                    </c:forEach>
                </c:if>
                </tbody>
            </table>
            <span id="chooseItem"></span>
            <c:if test="${userPage.list.size()=='0'}">
                <span style="color: #999999;margin: 20px 0 70px 20px;display: block;">未查询到相关内容</span>
            </c:if>
            <c:if test="${userPage.list.size()>0}">
                <div class="pagination">${userPage}</div>
            </c:if>
        </div>
        <li class="btns">
            <label style="width:auto;"><input id="btnConfirm" class="btn btn-primary" type="button" value="确定"/>&nbsp;&nbsp;
                <input id="btnClose" class="btn btn-primary" type="button" value="关闭"/></label>
        </li>
    </div>
</div>
</body>
</html>