<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务类型管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

		function addRow(list1,list2,list3, idx, tpl, row) {
			$(list1).append(Mustache.render(tpl, {
				idx: idx, delBtn: true, row: row
			}));
			$(list2 + idx).find("select").each(function () {
				$(this).val($(this).attr("data-value"));
			});
			$(list3 + idx).find("input[type='checkbox'], input[type='radio']").each(function () {
				var ss = $(this).attr("data-value").split(',');
				for (var i = 0; i < ss.length; i++) {
					if ($(this).val() == ss[i]) {
						$(this).attr("checked", "checked");
					}
				}
			});
			genSeqNo();
		}

		function delRow(obj, prefix) {
			var id = $(prefix + "_id");
			var delFlag = $(prefix + "_delFlag");
			delFlag.val("1");
			$(obj).parent().parent().remove();
			genSeqNo();
		}

		// 自动生成序号
		function genSeqNo() {
			var indx = 0;
			$('#scopeList').find("tr").each(function () {
				var tdArr = $(this).children();
				tdArr.eq(1).html(indx + 1);
				indx = indx + 1;
			});
		}

		/*跟据集团  获取对应的业务类型  和业务类别 */
		function getRegion(supplementGroup,supplementArea){
			var selectNode = $(supplementArea);

			selectNode.empty();//每次需要将上一次的数据进行清空
			selectNode.append("<option value=''>请选择</option>");


			var  ts_describe=  $(supplementGroup).val();
			if(ts_describe != null && ts_describe != ''){
				$.ajax({
					type: "POST",
					url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
					dataType: "json",
					success: function(returnedData) {
						var data1 = returnedData.ctBbtcRegionList;
						if (data1 != '') {
							var slsb=$(supplementArea);
							for (var i = 0;i < data1.length;i++){
								slsb.append(new Option(data1[i].name,data1[i].id));
							}
						}
					},error:function(data){
						alert("系统错误");
					}
				});
			}else{
				/*top.$.jBox.tip('请选择被举报集团', 'warning');*/
			}

		}

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/report/ctBbtcBusType/">业务类型列表</a></li>
		<li class="active"><a href="${ctx}/report/ctBbtcBusType/form?id=${ctBbtcBusType.id}">业务类型<shiro:hasPermission name="report:ctBbtcBusType:edit">${not empty ctBbtcBusType.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="report:ctBbtcBusType:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="ctBbtcBusType" action="${ctx}/report/ctBbtcBusType/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">业务类型编码：</label>
			<div class="controls">
				<form:input path="number" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">业务类型名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">使用范围：</label>
			<div class="controls">
				<table id="contentTable" class="table table-striped table-bordered table-condensed">
					<thead>
					<tr>
						<th class="hide"></th>
						<th>序号</th>
						<th>集团名称</th>
						<th>区域名称</th>
					</tr>
					</thead>
					<tbody id="scopeList">
					</tbody>
						<tfoot>
						<tr>
							<td colspan="7">
								<a href="javascript:"
								   onclick="addRow('#scopeList','#supplementGroup','#supplementArea', scopeRowIdx, scopeTpl);scopeRowIdx = scopeRowIdx + 1;"
								   class="btn">新增使用范围</a></td>
						</tr>
						</tfoot>
				</table>
				<script type="text/template" id="scopeTplReadOnly">//<!--
						<tr id="scopeList{{idx}}">
						<td class="hide">
								<input id="scopeList{{idx}}_id"  type="hidden" />
								<input id="scopeList{{idx}}_delFlag" type="hidden" />
							</td>
							<td></td>
							<td>
		<form:select id="supplementGroup{{idx}}" path="group" class="input-small required" onchange="getRegion('#supplementGroup{{idx}}','#supplementArea{{idx}}');"  cssStyle="width: 280px">
            <form:option value="">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                          htmlEscape="false"/>
        </form:select>
							</td>
							<td>
						 <form:select id="supplementArea{{idx}}" path="area" class="input-small required"  cssStyle="width: 280px">
								<form:option value="">请选择</form:option>
						 </form:select>
							</td>
						</tr>//-->
				</script>
				<script type="text/template" id="scopeTpl">//<!--
						<tr id="scopeList{{idx}}">
						<td class="hide">
								<input id="scopeList{{idx}}_id"  type="hidden" />
								<input id="scopeList{{idx}}_delFlag"  type="hidden" />
							</td>
						<td></td>
							<td>
		 <form:select id="supplementGroup{{idx}}"   path="group" class="input-small required" onchange="getRegion('#supplementGroup{{idx}}','#supplementArea{{idx}}');"  cssStyle="width: 280px">
            <form:option value="">请选择</form:option>
            <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                          htmlEscape="false"/>
        </form:select>
							</td>
<td>
					<form:select id="supplementArea{{idx}}" path="area" class="input-small required"  cssStyle="width: 280px">
								<form:option value="">请选择</form:option>
						 </form:select>
							</td>
							<td class="text-center" width="20">
								{{#delBtn}}<span class="close" onclick="delRow(this, '#scopeList{{idx}}')" title="删除">&times;</span>{{/delBtn}}
							</td>
						</tr>//-->
				</script>

				<script type="text/javascript">
					var scopeRowIdx = 0,
							scopeTpl = $("#scopeList").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),
							scopeTplReadOnly = $("#scopeTplReadOnly").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, "");

					/*数据回显=====================*/
					$(document).ready(function () {
						var data = ${fns:toJson(cloudAreaList)};
						for (var i = 0; i < data.length; i++) {
							if (data[i].isCanDelete != null && data[i].isCanDelete == '1') {
								alert(data[i].group);
								addRow('#scopeList','#supplementGroup','#supplementArea', scopeRowIdx, scopeTpl, data[i]);
							} else {
								addRow('#scopeList','#supplementGroup','#supplementArea', scopeRowIdx, scopeTplReadOnly, data[i]);
							}
							scopeRowIdx = scopeRowIdx + 1;
						}
					});
				</script>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="report:ctBbtcBusType:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>