package com.ejweb.modules.workbench.web;

import com.alibaba.fastjson.JSONObject;
import com.ejweb.core.base.BaseController;
import com.ejweb.core.utils.StringUtils;
import com.ejweb.modules.report.entity.CtBbtcBusCategory;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.service.CtBbtcBusCategoryService;
import com.ejweb.modules.report.service.CtBbtcBusTypeService;
import com.ejweb.modules.report.service.ReportService;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.sys.utils.UserUtils;
import com.ejweb.modules.workbench.Bean.WorkbenchBean;
import com.ejweb.modules.workbench.service.WorkbenchService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.List;

/**
 * Created by mengxy on 2017/9/12.
 */
@Controller
@RequestMapping("${adminPath}/workbench")
public class WorkbenchController extends BaseController {

    @Autowired
    private WorkbenchService workbenchService;
    @Autowired
    private ReportService reportService;

    @Autowired
    private CtBbtcBusTypeService ctBbtcBusTypeService;

    @Autowired
    private CtBbtcBusCategoryService ctBbtcBusCategoryService;




    @RequiresPermissions("workbench:view")
    @RequestMapping(value = {"list", ""})
    public String getWorkbench(Model model, WorkbenchBean bean) {



        WorkbenchBean workbench;
        try {
            User user = UserUtils.getUser();
            bean = getWorkbenchByUser(user, bean);
            if (StringUtils.isBlank(bean.getProcessStatus()) || "0".equals(bean.getProcessStatus())) {
                bean.setProcessStatus("0");
            } else if ("1".equals(bean.getProcessStatus())) {
                bean.setProcessStatus("1");
            }
            System.out.println("处理状态:======================================"+bean.getProcessStatus());
            List<ReportEntity> repList = workbenchService.getRepList(bean);

            /*封装类型  类别数据*/
            for (ReportEntity report: repList  ) {
                String  SupplementTypeStr="";
                String  SupplementCategoryStr="";
                /*遍历集合*/

                if(StringUtils.isNoneBlank(report.getSupplementType())){
                    String[] getSupplementTypeStr = report.getSupplementType().split(",");
                    for (String str:getSupplementTypeStr) {
                        CtBbtcBusType ctBbtcBusType = ctBbtcBusTypeService.get(str);
                        if(ctBbtcBusType!=null){
                            SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                        }else{
                            SupplementTypeStr = SupplementTypeStr + "--";
                        }

                    }
                    report.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
                }


                if(StringUtils.isNoneBlank(report.getSupplementCategory())){
                    String[] getSupplementCategory = report.getSupplementCategory().split(",");
                    for (String str:getSupplementCategory) {
                        CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                        if(ctBbtcBusCategory!=null){
                            SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                        }else{
                            SupplementCategoryStr = SupplementCategoryStr + "--";
                        }
                    }
                    report.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
                }

            }

            model.addAttribute("workbench", bean);
            model.addAttribute("repList", repList);
            /*将这一类状态返回*/
            model.addAttribute("reportStatus", bean.getProcessStatus());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "modules/workbench/workbench";
    }

    @RequestMapping("/getHighcharts")
    @ResponseBody
    public void getHighcharts(WorkbenchBean bean, HttpServletResponse response) {
        JSONObject res = new JSONObject();
        try {
            User user = UserUtils.getUser();
            bean = getWorkbenchByUser(user, bean);

            res.put("bench", bean);
            //区域
            res.put("supplementGroup",bean.getSupplementGroup());
            res.put("area",bean.getArea());
            //1.举报状态
            res.put("unProcess", bean.getUnProcess());
            res.put("processing", bean.getProcessing());
            res.put("processed", bean.getProcessed());
            res.put("closed", bean.getClosed());
            //3.举报结果
            res.put("unsettled", bean.getUnsettled());
            res.put("resultNum", bean.getComplainNum()+bean.getInvalid()+bean.getVerified()+bean.getConfirmed()+bean.getUnreaListic()+bean.getTransfer()+bean.getClue()); //總數
            res.put("complainNum", bean.getComplainNum()); //移交客诉
            res.put("invalid", bean.getInvalid());//举报无效
            res.put("verified", bean.getVerified()); //举报受理
            res.put("confirmed", bean.getConfirmed());//举报属实
            res.put("unreaListic", bean.getUnreaListic());//举报不实
            res.put("transfer", bean.getTransfer()); //移交其他部门
            res.put("clue", bean.getClue());//转为线索
            res.put("startDate", bean.getStartDate());
            res.put("endDate", bean.getEndDate());
            //4.举报类型
            res.put("sale", bean.getSale());
            res.put("project", bean.getProject());
            res.put("cost", bean.getCost());
            res.put("forMining", bean.getForMining());
            res.put("finance", bean.getFinance());
            res.put("forensic", bean.getForensic());
            res.put("administration", bean.getAdministration());
            res.put("manpower", bean.getManpower());
            res.put("development", bean.getDevelopment());
            res.put("rAndD", bean.getrAndD());
            res.put("iAndD", bean.getiAndD());
            res.put("Other", bean.getOther());
            res.put("propertyManagement", bean.getPropertyManagement());
            res.put("hotelManagement", bean.getHotelManagement());
            res.put("businessManagement", bean.getBusinessManagement());
            res.put("startDate", bean.getStartDate());
            res.put("endDate", bean.getEndDate());
            //2.举报途径
            res.put("weChat", bean.getWeChat());
            res.put("web", bean.getWeb());
            res.put("sunacE", bean.getSunacE());
            res.put("oa", bean.getOa());
            res.put("offline", bean.getOffline());
            res.put("phone", bean.getPhone());
            res.put("supplier", bean.getSupplier());
            res.put("email", bean.getEmail());
            res.put("visit", bean.getVisit());
            String jsonStr = res.toJSONString();
            PrintWriter out = response.getWriter();
            response.setContentType("application/json;charset=utf-8");
            out.write(jsonStr.toString());
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WorkbenchBean getWorkbenchByUser(User user, WorkbenchBean bean) {
        if (user != null) {
            try {
                //判断登录人的角色
                String roleName = reportService.findRole(user);
                if (StringUtils.isNotBlank(roleName)) {
                    bean.setUserRoleName(roleName);
                    if (!roleName.equals("系统管理员")) {
                        bean.setIsAdmin(user.getId());
                    }
                }
                bean = workbenchService.getWorkbench(bean);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bean;
    }
}
