/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.ejweb.modules.report.entity;

import org.hibernate.validator.constraints.Length;

import com.ejweb.core.persistence.DataEntity;

/**
 * 业务类别Entity
 * @author haoqm
 * @version 2019-07-12
 */
public class CtBbtcBusCategory extends DataEntity<CtBbtcBusCategory> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 业务类别编码
	private String name;		// 业务类别名称
	private CtBbtcBusType type;		// 所属业务类型
	private String typeName;		// 所属业务类型名称
	private  String  ctBbtcGroup;   //所属集团
	private  String  supplementArea;   //所属区域

	public String getSupplementArea() {
		return supplementArea;
	}

	public void setSupplementArea(String supplementArea) {
		this.supplementArea = supplementArea;
	}

	public String getCtBbtcGroup() {
		return ctBbtcGroup;
	}

	public void setCtBbtcGroup(String ctBbtcGroup) {
		this.ctBbtcGroup = ctBbtcGroup;
	}

	public CtBbtcBusCategory() {
		super();
	}

	public CtBbtcBusCategory(String id){
		super(id);
	}

	@Length(min=0, max=64, message="业务类别编码长度必须介于 0 和 64 之间")
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@Length(min=0, max=255, message="业务类别名称长度必须介于 0 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}


	public CtBbtcBusType getType() {
		return type;
	}

	public void setType(CtBbtcBusType type) {
		this.type = type;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}
	
}