/*
 * Decompiled with CFR 0.152.
 */
package org.geo.split;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geo.split.PostfixNode;
import org.geo.split.RegionEntity;
import org.geo.split.RegionNode;
import org.geo.split.util.IOUtils;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.WoodInterface;
import org.nlpcn.commons.lang.tire.library.Library;

public class RegionLibrary {
    private static int autoid = 1;
    private static final Map<String, RegionNode> data = new HashMap<String, RegionNode>();
    private static final Map<String, Integer> regionNames = new HashMap<String, Integer>();
    private static final List<String> fullNames = new ArrayList<String>();
    private static final Forest forest = new Forest();

    static {
        fullNames.add("");
        List<String> cities = null;
        try {
            cities = IOUtils.readLines(Thread.currentThread().getContextClassLoader().getResourceAsStream("regions.dic"));
            if (cities != null) {
                for (String city : cities) {
                    if ((city = RegionLibrary.unescapeJavaString(city).trim()).startsWith("#")) continue;
                    RegionLibrary.add(RegionLibrary.unescapeJavaString(city));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            cities = null;
            File config = new File("regions.dic");
            if (config.exists() && config.canRead() && (cities = IOUtils.readLines(new BufferedInputStream(new FileInputStream(config)))) != null) {
                for (String city : cities) {
                    if ((city = RegionLibrary.unescapeJavaString(city).trim()).startsWith("#")) continue;
                    RegionLibrary.add(city);
                }
            }
            cities = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeJavaString(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (i < st.length()) {
            block17: {
                int ch;
                block15: {
                    char nextChar;
                    block16: {
                        ch = st.charAt(i);
                        if (ch != 92) break block15;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block16;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = String.valueOf(code) + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = String.valueOf(code) + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block17;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block17;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmtpy(String org) {
        return org == null || org.isEmpty();
    }

    public static void add(String line) {
        if (RegionLibrary.isEmtpy(line)) {
            return;
        }
        String[] regions = line.trim().split("\\s+");
        String postcode = regions[regions.length - 1];
        if (postcode.matches("\\d{6}")) {
            int i = 0;
            int len = regions.length - 1;
            while (i < len) {
                int j = 0;
                int parent = 0;
                while (j <= i - 1) {
                    parent = RegionLibrary.getRegionId(parent, regions[j]);
                    ++j;
                }
                String region = regions[i];
                String prefix = region.substring(0, 2);
                String postfix = region.substring(2);
                Library.insertWord((WoodInterface)forest, (String)(String.valueOf(region) + "\t1"));
                Library.insertWord((WoodInterface)forest, (String)(String.valueOf(prefix) + "\t0"));
                RegionNode node = data.get(prefix);
                if (node == null) {
                    node = new RegionNode(prefix);
                }
                if (region.length() >= 2) {
                    if (i == len - 1) {
                        node.addSuffixes(postfix, parent, i, postcode);
                    } else {
                        node.addSuffixes(postfix, parent, i, null);
                    }
                }
                data.put(prefix, node);
                ++i;
            }
        } else {
            int i = 0;
            int len = regions.length;
            while (i < len) {
                int j = 0;
                int parent = 0;
                while (j <= i - 1) {
                    parent = RegionLibrary.getRegionId(parent, regions[j]);
                    ++j;
                }
                String region = regions[i];
                String prefix = region.substring(0, 2);
                String postfix = region.substring(2);
                Library.insertWord((WoodInterface)forest, (String)(String.valueOf(region) + "\t1"));
                Library.insertWord((WoodInterface)forest, (String)(String.valueOf(prefix) + "\t0"));
                RegionNode node = data.get(prefix);
                if (node == null) {
                    node = new RegionNode(prefix);
                }
                if (region.length() >= 2) {
                    node.addSuffixes(postfix, parent, i, null);
                }
                data.put(prefix, node);
                ++i;
            }
        }
    }

    private static int getRegionId(int parent, String region) {
        String key = String.valueOf(parent) + " " + region;
        if (regionNames.get(key) == null) {
            fullNames.add(autoid, key);
            regionNames.put(key, autoid);
            ++autoid;
        }
        return regionNames.get(key);
    }

    public static void display() {
        for (Map.Entry<String, RegionNode> region : data.entrySet()) {
            RegionNode node = region.getValue();
            for (PostfixNode suffix : node.getSuffixes()) {
                System.out.println(RegionLibrary.full(node, suffix));
            }
        }
    }

    public static List<String> getItems(String content) {
        return RegionLibrary.getItems(content, false);
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> getItems(String content, boolean all) {
        block3: {
            if (RegionLibrary.isEmtpy(content) || content.length() < 2) {
                return null;
            }
            udg = RegionLibrary.forest.getWord(content);
            items = new ArrayList<String>();
            temp = null;
            if (!all) ** GOTO lbl14
            while ((temp = udg.getAllWords()) != null) {
                items.add(String.valueOf(temp) + " " + udg.getParam(0));
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                items.add(String.valueOf(temp) + " " + udg.getParam(0));
lbl14:
                // 2 sources

                ** while ((temp = udg.getFrontWords()) != null)
            }
        }
        return items;
    }

    public static RegionNode get(String key) {
        if (RegionLibrary.isEmtpy(key) || key.length() < 2) {
            return null;
        }
        return data.get(key.substring(0, 2));
    }

    public static RegionEntity full(RegionNode node, PostfixNode suffix) {
        String prefix = node.getRegionPrefix();
        String fullname = String.valueOf(prefix) + suffix.getPostfix();
        int parent = suffix.getParent();
        while (parent != 0) {
            String reg = fullNames.get(parent);
            String[] entities = reg.split(" ");
            fullname = String.valueOf(entities[1]) + " " + fullname;
            parent = Integer.parseInt(entities[0]);
        }
        RegionEntity region = new RegionEntity(fullname, suffix.getPostcode());
        region.setLevel(suffix.getLevel());
        region.setParent(suffix.getParent());
        return region;
    }

    public static String fullParent(int parent) {
        String fullname = "";
        while (parent != 0) {
            String reg = fullNames.get(parent);
            String[] entities = reg.split(" ");
            fullname = String.valueOf(entities[1]) + " " + fullname;
            parent = Integer.parseInt(entities[0]);
        }
        return fullname.isEmpty() ? null : fullname;
    }

    public static String parent(int parent) {
        if (parent == 0) {
            return null;
        }
        String region = fullNames.get(parent);
        String[] entities = region.split("\\s+");
        return entities[1];
    }
}

