<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>用户管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            getRegion();
            $("#no").focus();
            $("#inputForm").validate({
                rules: {
                    loginName: {remote: "${ctx}/sys/user/checkLoginName?oldLoginName=" + encodeURIComponent('${user.loginName}')}
                },
                messages: {
                    loginName: {remote: "用户登录名已存在"},
                    confirmNewPassword: {equalTo: "输入与上面相同的密码"}
                },
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

        function getRegion(){
            var selectNode = $("#supplementArea");
            selectNode.empty();//每次需要将上一次的数据进行清空
            selectNode.append("<option value=''>请选择</option>");

            var  ts_describe=  $("#supplementGroup").val();
            if(ts_describe != null && ts_describe != ''){
                $.ajax({
                    type: "POST",
                    url: "${ctx}/report/ctBbtcRegion/getRegionList?groupId="+ts_describe,
                    dataType: "json",
                    success: function(returnedData) {
                        console.log(returnedData);
                        var data1 = returnedData.ctBbtcRegionList;
//                            console.log(data1[0].name);
//                            console.log(data2[0].name);
                        var supplementArea=$("#hiddenArea").val();
                     if (data1 != '') {
                            var slsb=$("#supplementArea");

                         for (var i = 0;i < data1.length;i++){
                              /*  slsb.append(new Option(data1[i].name,data1[i].id) );*/
                                var value=data1[i].id;
                                var  label=data1[i].name;
                                if(supplementArea == label){
                                    slsb.append("<option value="+value+" selected='true'  >"+label+"</option>");
                                    try {
                                        $('#s2id_supplementArea').find('.select2-chosen').html(label);
                                    } catch (e) {
                                        console.log(e);
                                    }
                                }else{
                                    slsb.append("<option value="+value+" >"+label+"</option>");
                                }
                            }
                        }

                    },error:function(data){
                        alert("系统错误");
                    }
                });
            }else{
               /* top.$.jBox.tip('请选择被举报集团', 'warning');*/
            }

        }
    </script>

</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/sys/user/list">用户列表</a></li>
    <li class="active"><a href="${ctx}/sys/user/form?id=${user.id}">用户<shiro:hasPermission
            name="sys:user:edit">${not empty user.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="sys:user:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>

<form:form id="inputForm" modelAttribute="user"  action="${ctx}/sys/user/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <%--<div class="control-group">
        <label class="control-label">头像:</label>
        <div class="controls">
            <form:hidden id="nameImage" path="photo" htmlEscape="false" maxlength="255" class="input-xlarge"/>
            <sys:ckfinder input="nameImage" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
        </div>
    </div>--%>
    <%--<div class="control-group">
        <label class="control-label">归属公司:</label>
        <div class="controls">
            <sys:treeselect id="company" name="company.id" value="${user.company.id}" labelName="company.name" labelValue="${user.company.name}"
                title="公司" url="/sys/office/treeData?type=1" />
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">归属部门:</label>
        <div class="controls">
            <sys:treeselect id="office" name="office.id" value="${user.office.id}" labelName="office.name" labelValue="${user.office.name}"
                title="部门" url="/sys/office/treeData?type=2" notAllowSelectParent="true"/>
        </div>
    </div>--%>
    <%--<div class="control-group">
        <label class="control-label">工号:</label>
        <div class="controls">
            <form:input path="no" htmlEscape="false" maxlength="50" class="required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>--%>
    <div class="control-group">
        <label class="control-label">姓名:</label>
        <div class="controls">
            <form:input path="name" htmlEscape="false" maxlength="50" class="required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">登录名:</label>
        <div class="controls">
            <input id="oldLoginName" name="oldLoginName" type="hidden" value="${user.loginName}">
            <form:input path="loginName" htmlEscape="false" maxlength="50" class="required userName"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">所属集团:</label>
        <div class="controls">
            <form:select id="supplementGroup" path="supplementGroup" class="input-small " onchange="getRegion()"  cssStyle="width: 220px">
                <form:option value="">请选择</form:option>
                <form:options items="${fns:getDictList('supplement_group')}" itemLabel="label" itemValue="id"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">所属区域:</label>
        <div class="controls">
            <input type="hidden" value="${user.area}" id="hiddenArea">
            <form:select id="supplementArea" path="area" class="input-small "  cssStyle="width: 220px">
                <form:option value="">请选择</form:option>
                <%--<form:options items="${ctBbtcRegionList}" itemLabel="name" itemValue="id"
                              htmlEscape="false"/>--%>
            </form:select>
          <%--  <select id="supplementArea" name="area" class="input-small" style="width:220px ">
                <option value="">请选择</option>
            </select>--%>
          <%--  <span class="help-inline"><font color="red">*</font> </span>--%>
        </div>
    </div>
    <%--<div class="control-group">
        <label class="control-label">密码:</label>
        <div class="controls">
            <input id="newPassword" name="newPassword" type="password" value="" maxlength="50" minlength="3" class="${empty user.id?'required':''}"/>
            <c:if test="${empty user.id}"><span class="help-inline"><font color="red">*</font> </span></c:if>
            <c:if test="${not empty user.id}"><span class="help-inline">若不修改密码，请留空。</span></c:if>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">确认密码:</label>
        <div class="controls">
            <input id="confirmNewPassword" name="confirmNewPassword" type="password" value="" maxlength="50" minlength="3" equalTo="#newPassword"/>
            <c:if test="${empty user.id}"><span class="help-inline"><font color="red">*</font> </span></c:if>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">邮箱:</label>
        <div class="controls">
            <form:input path="email" htmlEscape="false" maxlength="100" class="email"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">电话:</label>
        <div class="controls">
            <form:input path="phone" htmlEscape="false" maxlength="100"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">手机:</label>
        <div class="controls">
            <form:input path="mobile" htmlEscape="false" maxlength="100"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否允许登录:</label>
        <div class="controls">
            <form:select path="loginFlag">
                <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> “是”代表此账号允许登录，“否”则表示此账号不允许登录</span>
        </div>
    </div>--%>
    <%-- <div class="control-group">
         <label class="control-label">用户类型:</label>
         <div class="controls">
             <form:select path="userType" class="input-xlarge">
                 <form:option value="" label="请选择"/>
                 <form:options items="${fns:getDictList('sys_user_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
             </form:select>
         </div>
     </div>--%>
    <div class="control-group">
        <label class="control-label">用户角色:</label>
        <div class="controls">
            <form:checkboxes path="roleIdList" items="${allRoles}" itemLabel="name" itemValue="id" htmlEscape="false"
                             class="required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <%--<div class="control-group">
        <label class="control-label">备注:</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="3" maxlength="200" class="input-xlarge"/>
        </div>
    </div>
    <c:if test="${not empty user.id}">
        <div class="control-group">
            <label class="control-label">创建时间:</label>
            <div class="controls">
                <label class="lbl"><fmt:formatDate value="${user.createDate}" type="both" dateStyle="full"/></label>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">最后登陆:</label>
            <div class="controls">
                <label class="lbl">IP: ${user.loginIp}&nbsp;&nbsp;&nbsp;&nbsp;时间：<fmt:formatDate value="${user.loginDate}" type="both" dateStyle="full"/></label>
            </div>
        </div>
    </c:if>--%>
    <div class="form-actions">
        <shiro:hasPermission name="sys:user:edit"><input id="btnSubmit" class="btn btn-primary" type="submit"
                                                         value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>