package com.ejweb.modules.workbench.web;

import com.ejweb.core.base.BaseController;
import com.ejweb.core.persistence.Page;
import com.ejweb.modules.report.service.ReportService;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.sys.utils.UserUtils;
import com.ejweb.modules.workbench.entity.ReportNotice;
import com.ejweb.modules.workbench.entity.ReportNoticeEntity;
import com.ejweb.modules.workbench.service.NoticeService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by mengxy on 2017/9/15.
 */
@Controller
@RequestMapping(value = "${adminPath}/notice")
public class NoticeController extends BaseController {

    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ReportService reportService;

    @RequiresPermissions("notice:view")
    @RequestMapping("list")
    public String list(HttpServletRequest request, HttpServletResponse response, Model model){
        try {
            //获取登录用户
            User user = UserUtils.getUser();
            if(user != null){
                //判断登录人的角色
                String roleName = reportService.findRole(user);
                if (StringUtils.isNotBlank(roleName)) {
                    String isAdmin = "";
                    if (roleName.equals("系统管理员")) {
                        isAdmin = "Y";
                    }else {
                        isAdmin = "N";
                    }
//                    Page<ReportNotice> noticePage = noticeService.selectBySendToId(new Page<ReportNotice>(request, response),new ReportNotice(),user.getId());
                    ReportNoticeEntity reportNoticeEntity = new ReportNoticeEntity();
                    reportNoticeEntity.setSendToId(user.getId());
                    Page<ReportNoticeEntity> noticePage = noticeService.findPage(new Page<ReportNoticeEntity>(request, response),reportNoticeEntity);
                    int i = 0;
                    String idArray = "";
                    for(ReportNoticeEntity notice:noticePage.getList()) {
                        if("0".equals(notice.getStatus())){
                            if (i == 0) {
                                idArray += notice.getId();
                            } else {
                                idArray += "," + notice.getId();
                            }
                            i++;
                        }
                    }
                    model.addAttribute("isAdmin",isAdmin);
                    model.addAttribute("noticePage",noticePage);
                    model.addAttribute("idArray",idArray);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "modules/workbench/notice";
    }

    @RequestMapping("view")
    public String view(String id,String reportId){
        try {
            ReportNotice notice = new ReportNotice();
            notice.setId(id);
            noticeService.updateByPrimaryKeySelective(notice);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "redirect:" + adminPath + "/report/view?id="+reportId;
    }

    @RequestMapping("read")
    public String read(String idArray){
        try {
            if(StringUtils.isNotBlank(idArray)){
                String[] ids = idArray.split(",");
                for (int i=0;i<ids.length;i++){
                    ReportNotice notice = new ReportNotice();
                    notice.setId(ids[i]);
                    noticeService.updateByPrimaryKeySelective(notice);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "redirect:" + adminPath + "/notice/list";
    }

    @RequestMapping("prompt")
    public void getMessageCount(HttpServletResponse response) throws IOException {
        User user = UserUtils.getUser();
        Integer count = noticeService.getMessageCount(user.getId());
        String result = "";
        if (count != 0){
            result = count.toString();
        }
        PrintWriter out = response.getWriter();
        response.setContentType("application/json;charset=utf-8");
        out.write(result);
        out.close();
    }
}
