package com.ejweb.modules.report.web;

import com.ejweb.core.base.BaseController;
import com.ejweb.core.persistence.Page;
import com.ejweb.core.utils.DateUtils;

import com.ejweb.core.utils.SpringContextHolder;
import com.ejweb.core.utils.StringUtils;

import com.ejweb.core.utils.excel.ExportExcel;
import com.ejweb.modules.report.dao.CtBbtcBusTypeDao;
import com.ejweb.modules.report.dao.ReportDao;
import com.ejweb.modules.report.entity.CtBbtcBusCategory;
import com.ejweb.modules.report.entity.CtBbtcBusType;
import com.ejweb.modules.report.entity.ReportAttachmentEntity;
import com.ejweb.modules.report.entity.ReportEntity;
import com.ejweb.modules.report.service.CtBbtcBusCategoryService;
import com.ejweb.modules.report.service.CtBbtcBusTypeService;
import com.ejweb.modules.report.service.ReportService;
import com.ejweb.modules.sys.entity.Office;
import com.ejweb.modules.sys.entity.Position;
import com.ejweb.modules.sys.entity.User;
import com.ejweb.modules.sys.utils.UserUtils;
import com.ejweb.modules.workbench.service.NoticeService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import com.google.common.collect.Lists;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import java.util.*;

/**
 * 举报Controller
 *
 * @author lixy
 * @version 2017-09-06
 */
@Controller
@RequestMapping(value = "${adminPath}/report")
public class ReportController extends BaseController {

    @Autowired
    private ReportService reportService;
    @Autowired
    private NoticeService noticeService;

    @Autowired
    private ReportDao reportdao;

    @Autowired
    protected CtBbtcBusTypeService  CtBbtcBusTypeService;

    @Autowired
    protected CtBbtcBusCategoryService ctBbtcBusCategoryService;


    @ModelAttribute
    public ReportEntity get(@RequestParam(required = false) String id) {
        if (StringUtils.isNotBlank(id)) {
            return reportService.get(id);
        } else {
            return new ReportEntity();
        }
    }

    /**
     * 集团举报列表
     *
     * @param reportEntity
     * @param model
     * @param request
     * @param response
     * @return
     */
    @RequiresPermissions("report:view")
    @RequestMapping(value = {"list", ""})
    public String list(ReportEntity reportEntity, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
        //判断登录人的角色
        User user = UserUtils.getUser();
//        User user = UserUtils.getByLoginName("wuhaifeng1");
        //判断标签状态 flag为空，跳转到核查中举报列表 flag为0，跳转到未处理举报列表 flag为1，跳转到举报列表, flag为2，跳转到已处理举报列表
        if (StringUtils.isNotBlank(flag)) {
            if (flag.equals("0")) {
                if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                    reportEntity.setReportStatus("0");
                }
            } else {
                if (flag.equals("4")) {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setDealResult("7");
                        reportEntity.setFlage("1");
                    }
                } else {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setReportStatus("1");
                    }
                }
            }
        }


        Page<ReportEntity> page = new Page<ReportEntity>(request, response);
        page.setPageSize(10);
        //判断登录人是区域管理员还是集团管理员
        if ((!reportService.checkRole(user).equals("1")) && (!reportService.checkRole(user).equals("2"))) {
            reportEntity.setExchangeAfterUser(user.getId());
            page = reportService.findPage(page, reportEntity);
        } else if (reportService.checkRole(user).equals("2")) {
            reportEntity.setIsFzAdmin("2");
            reportEntity.setExchangeBeforeUser(user.getId());
            page = reportService.findPage(page, reportEntity);
        } else {
            reportEntity.setIsAdmin("1");
            page = reportService.findPage(page, reportEntity);
        }

        List<ReportEntity> reportlist = page.getList();

        /*封装类型  类别数据*/
        for (ReportEntity report: reportlist  ) {
            String  SupplementTypeStr="";
            String  SupplementCategoryStr="";

            /*遍历集合*/

            if(StringUtils.isNoneBlank(report.getSupplementType())){
                String[] getSupplementTypeStr = report.getSupplementType().split(",");
                for (String str:getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = CtBbtcBusTypeService.get(str);
                    if(ctBbtcBusType!=null){
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    }else{
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                report.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if(StringUtils.isNoneBlank(report.getSupplementCategory())){
                String[] getSupplementCategory = report.getSupplementCategory().split(",");
                for (String str:getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                    if(ctBbtcBusCategory!=null){
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    }else{
                        SupplementCategoryStr = SupplementCategoryStr + "--";
                    }
                }
                report.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }

        }


        /*for (ReportEntity report : reportlist) {
            String departmentStr = "";
            if (StringUtils.isNoneBlank(report.getSupplementType())) {
                String[] types = report.getSupplementType().split(",");
                for (String value : types) {
                    if (value.equals("1")) {
                        value = "营销";
                    } else if (value.equals("2")) {
                        value = "工程";
                    } else if (value.equals("3")) {
                        value = "成本";
                    } else if (value.equals("4")) {
                        value = "招采";
                    } else if (value.equals("5")) {
                        value = "财务";
                    } else if (value.equals("6")) {
                        value = "法务";
                    } else if (value.equals("7")) {
                        value = "行政";
                    } else if (value.equals("8")) {
                        value = "人力";
                    } else if (value.equals("9")) {
                        value = "开发";
                    } else if (value.equals("10")) {
                        value = "研发";
                    } else if (value.equals("11")) {
                        value = "投资";
                    } else if (value.equals("12")) {
                        value = "其他";
                    } else if (value.equals("13")) {
                        value = "物业管理";
                    } else if (value.equals("14")) {
                        value = "文旅管理";
                    } else if (value.equals("15")) {
                        value = "商业";
                    }
                    departmentStr = departmentStr + value + ",";
                }
                report.setSupplementType(departmentStr.substring(0, departmentStr.length() - 1));
            }
        }*/

       /* String value = "";*/
        /*for (ReportEntity report : reportlist) {
            if (StringUtils.isNoneBlank(report.getOaarea())) {
                if (report.getOaarea().equals("North China")) {
                    value = "华北区域公司";
                } else if (report.getOaarea().equals("BeiJing")) {
                    value = "北京区域公司";
                } else if (report.getOaarea().equals("ShangHai")) {
                    value = "上海区域公司";
                } else if (report.getOaarea().equals("SouthWest")) {
                    value = "西南区域公司";
                } else if (report.getOaarea().equals("SouthEast")) {
                    value = "东南区域公司";
                } else if (report.getOaarea().equals("Central China")) {
                    value = "华中区域公司";
                } else if (report.getOaarea().equals("GuangShen")) {
                    value = "广深区域公司";
                } else if (report.getOaarea().equals("Hainan")) {
                    value = "海南区域公司";
                } else if (report.getOaarea().equals("Group")) {
                    value = "集团本部";
                } else if (report.getOaarea().equals("PropertyGroup")) {
                    value = "物业集团";
                }
                if (StringUtils.isNoneBlank(report.getOaname())) {
                    report.setOaname(value + "-" + report.getOaname());
                }
            }
            String exchangeAfterUser = reportdao.selectExchangeAfterUser(report.getExchangeAfterUser());
            report.setTransferName(exchangeAfterUser);
        }*/

        page.setList(reportlist);
        String isAdmin = reportService.checkRole(user);
        model.addAttribute("page", page);
        model.addAttribute("report", reportEntity);
        model.addAttribute("flag", flag);
        model.addAttribute("isAdmin", isAdmin);
        return "modules/report/reportList";
    }


    /**
     * 区域举报列表
     *
     * @param reportEntity
     * @param model
     * @param request
     * @param response
     * @return
     */


    @RequestMapping(value = "qylist")
    public String qyList(ReportEntity reportEntity, String flag, HttpServletRequest
            request, HttpServletResponse response, Model model) {
        //判断登录人的角色
        User user = UserUtils.getUser();
        //判断标签状态 flag为空，跳转到核查中举报列表 flag为0，跳转到未处理举报列表 flag为1，跳转到举报列表 flag为2，跳转到已处理举报列表
        if (StringUtils.isNotBlank(flag)) {
            if (flag.equals("0")) {
                if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                    reportEntity.setReportStatus("0");
                }
            } else {
                if (flag.equals("4")) {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setDealResult("7");
                        reportEntity.setFlage("1");
                    }
                } else {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setReportStatus("1");
                    }
                }
            }
        }

        Page<ReportEntity> page = new Page<ReportEntity>(request, response);
        page.setPageSize(10);
//        if (!reportService.checkRole(user).equals("1")) {
//
//            page = reportService.findQyList(page, reportEntity);
//        } else {
//            reportEntity.setIsAdmin("1");
//            page = reportService.findQyList(page, reportEntity);
//        }


        if ((!reportService.checkRole(user).equals("1")) && (!reportService.checkRole(user).equals("2"))) {
            reportEntity.setExchangeAfterUser(user.getId());
            page = reportService.findQyList(page, reportEntity);
        } else if (reportService.checkRole(user).equals("2")) {
            reportEntity.setIsFzAdmin("2");
            reportEntity.setExchangeBeforeUser(user.getId());
            page = reportService.findQyList(page, reportEntity);
        } else {
            reportEntity.setIsAdmin("1");
            page = reportService.findQyList(page, reportEntity);
        }

        List<ReportEntity> reportlist = page.getList();
        /*封装类型  类别数据*/
        for (ReportEntity report: reportlist  ) {
            String  SupplementTypeStr="";
            String  SupplementCategoryStr="";
            /*遍历集合*/

            if(StringUtils.isNoneBlank(report.getSupplementType())){
                String[] getSupplementTypeStr = report.getSupplementType().split(",");
                for (String str:getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = CtBbtcBusTypeService.get(str);
                    if(ctBbtcBusType!=null){
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    }else{
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                report.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if(StringUtils.isNoneBlank(report.getSupplementCategory())){
                String[] getSupplementCategory = report.getSupplementCategory().split(",");
                for (String str:getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                    if(ctBbtcBusCategory!=null){
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    }else{
                        SupplementCategoryStr = SupplementCategoryStr + "--";
                    }
                }
                report.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }


        }

        page.setList(reportlist);
        String isAdmin = reportService.checkRole(user);
        model.addAttribute("page", page);
        model.addAttribute("report", reportEntity);
        model.addAttribute("flag", flag);
        model.addAttribute("isAdmin", isAdmin);
        return "modules/report/reportQyList";
    }


    /**
     * 举报添加
     *
     * @param reportEntity
     * @param model
     * @return
     */
    @RequestMapping(value = "form")
    public String form(ReportEntity reportEntity, Model model) {
        model.addAttribute("report", reportEntity);
        return "modules/report/reportForm";
    }

    /**
     * 举报信息保存
     *
     * @param reportEntity
     * @param model
     * @return
     */
    @RequestMapping(value = "addReport")
    public String addReport(ReportEntity reportEntity, HttpServletRequest request, Model
            model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, reportEntity)) {
            return form(reportEntity, model);
        }
        reportService.saveReport(reportEntity, request);
        addMessage(redirectAttributes, "添加举报" + reportEntity.getReportProject() + "'成功");
        System.out.println(reportEntity.getCreateBy()+"===================================");
        return "redirect:" + adminPath + "/report/list/?repage&flag=0";
    }

    /**
     * 举报详情
     *
     * @param reportEntity
     * @param model
     * @return
     */
    @RequestMapping(value = "view")
    public String view(ReportEntity reportEntity, Model model, RedirectAttributes redirectAttributes) {
        //判断登录人的角色
        User useradmin = UserUtils.getUser();
        String isAdmin = reportService.checkRole(useradmin);
        //获取举报提交文件列表
        ReportAttachmentEntity reportAttachment = new ReportAttachmentEntity();
        reportAttachment.setReportId(reportEntity.getId());
        reportAttachment.setAttachmentType("0");
        //跟据id查询举报信息
        ReportEntity reportEntity1 = reportService.get(reportEntity.getId());
        /*封装类型  类别数据*/
            String  SupplementTypeStr="";
            String  SupplementCategoryStr="";
            /*遍历集合*/

            if(StringUtils.isNoneBlank(reportEntity1.getSupplementType())){
                String[] getSupplementTypeStr = reportEntity1.getSupplementType().split(",");
                for (String str:getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = CtBbtcBusTypeService.get(str);
                    if(ctBbtcBusType!=null){
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    }else{
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                reportEntity1.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if(StringUtils.isNoneBlank(reportEntity1.getSupplementCategory())){
                String[] getSupplementCategory = reportEntity1.getSupplementCategory().split(",");
                for (String str:getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                    if(ctBbtcBusCategory!=null){
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    }else{
                        SupplementCategoryStr = SupplementCategoryStr + "--";
                    }
                }
                reportEntity1.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }




       /* if (StringUtils.isNoneBlank(reportEntity.getSupplementType())) {
            String supplementType = "";
            String[] supplementTypes = {"营销", "工程", "成本", "招采", "财务", "法务", "行政", "人力", "开发", "研发", "投资", "其他", "物业管理", "文旅管理","商业"};

            String typeNumber[] = reportEntity.getSupplementType().split(",");
            for (int i = 0; i < typeNumber.length; i++) {
                supplementType += supplementTypes[Integer.valueOf(typeNumber[i]) - 1] + ",";
            }
            supplementType = supplementType.substring(0, supplementType.length() - 1);
            reportEntity.setSupplementType(supplementType);
        }*/
        String isSendEmail = reportEntity.getIsSendEmail();
        if (StringUtils.isNotBlank(isSendEmail)) {
            if (isSendEmail.equals("1")) {
                isSendEmail = "是";
            }
        } else {
            isSendEmail = "否";
        }
        reportEntity.setIsSendEmail(isSendEmail);
        List<ReportAttachmentEntity> reportAttachmentList = reportService.getAttachmentInfo(reportAttachment);
        //获取补充提交文件列表
        ReportAttachmentEntity supplementAttachment = new ReportAttachmentEntity();
        supplementAttachment.setReportId(reportEntity.getId());
        supplementAttachment.setAttachmentType("1");
        List<ReportAttachmentEntity> supplementAttachmentList = reportService.getAttachmentInfo(supplementAttachment);
        //获取处理成果文件列表
        ReportAttachmentEntity dealAttachment = new ReportAttachmentEntity();
        dealAttachment.setReportId(reportEntity.getId());
        dealAttachment.setAttachmentType("2");
        List<ReportAttachmentEntity> dealAttachmentList = reportService.getAttachmentInfo(dealAttachment);
        //修改消息中心的未读消息提醒
        User user = UserUtils.getUser();
        Integer count = noticeService.getMessageCount(user.getId());
        String result = "";
        if (count != 0) {
            result = count.toString();
        }

       /* if (StringUtils.isNotBlank(reportEntity.getTransferDepartment())) {

            if (reportEntity.getTransferDepartment().equals("1")) {
                reportEntity.setTransferDepartment("营销");
            } else if (reportEntity.getTransferDepartment().equals("2")) {
                reportEntity.setTransferDepartment("工程");
            } else if (reportEntity.getTransferDepartment().equals("3")) {
                reportEntity.setTransferDepartment("成本");
            } else if (reportEntity.getTransferDepartment().equals("4")) {
                reportEntity.setTransferDepartment("招采");
            } else if (reportEntity.getTransferDepartment().equals("5")) {
                reportEntity.setTransferDepartment("财务");
            } else if (reportEntity.getTransferDepartment().equals("6")) {
                reportEntity.setTransferDepartment("法务");
            } else if (reportEntity.getTransferDepartment().equals("7")) {
                reportEntity.setTransferDepartment("行政");
            } else if (reportEntity.getTransferDepartment().equals("8")) {
                reportEntity.setTransferDepartment("人力");
            } else if (reportEntity.getTransferDepartment().equals("9")) {
                reportEntity.setTransferDepartment("开发");
            } else if (reportEntity.getTransferDepartment().equals("10")) {
                reportEntity.setTransferDepartment("研发");
            } else if (reportEntity.getTransferDepartment().equals("11")) {
                reportEntity.setTransferDepartment("投资");
            } else if (reportEntity.getTransferDepartment().equals("15")) {
                reportEntity.setTransferDepartment("商业");
            } else if (reportEntity.getTransferDepartment().equals("12")) {
                reportEntity.setTransferDepartment("其他");
            } else if (reportEntity.getTransferDepartment().equals("13")) {
                reportEntity.setTransferDepartment("物业管理");
            } else if (reportEntity.getTransferDepartment().equals("14")) {
                reportEntity.setTransferDepartment("文旅管理");
            }
        }*/

        /*封装拼接移交集团信息*/
      /*  String transferGroup = reportEntity1.getTransferGroup();
        if(StringUtils.isNoneBlank(transferGroup)){
            if("3437402691677202102".equals(transferGroup)){
                reportEntity1.setTransferGroup("集团本部");
            }else if("3510129313047280678".equals(transferGroup)){
                reportEntity1.setTransferGroup("区域集团");
            }else if("3565898923067676254".equals(transferGroup)){
                reportEntity1.setTransferGroup("服务集团");
            }else if("3806696792996264972".equals(transferGroup)){
                reportEntity1.setTransferGroup("文化集团");
            }else if("3770618512934949260".equals(transferGroup)){
                reportEntity1.setTransferGroup("文旅集团");
            }

        }else{
            reportEntity1.setTransferGroup("--");
        }*/

        if (isAdmin.equals("1") || isAdmin.equals("2")) {
            model.addAttribute("ifClue", true);
        } else {
            if (reportEntity.getExchangeType() == null || !(reportEntity.getIfClue().equals("2"))) {
                model.addAttribute("ifClue", true);
            }
        }
        model.addAttribute("isAdmin", isAdmin);
        model.addAttribute("report", reportEntity1);
        model.addAttribute("reportAttachmentList", reportAttachmentList);
        model.addAttribute("supplementAttachmentList", supplementAttachmentList);
        model.addAttribute("dealAttachmentList", dealAttachmentList);
        model.addAttribute("result", result);
        return "modules/report/reportDetail";
    }

    /**
     * 举报跟踪
     *
     * @param reportEntity
     * @param model
     * @return
     */
    @RequestMapping(value = "track")
    public String track(ReportEntity reportEntity, HttpServletRequest request, HttpServletResponse
            response, Model model) {

        String oldType="";   //先记录下转换前的type id组

        String oldCat="";   //先记录下转换前的cat id组
        //判断登录人的角色
        User user = UserUtils.getUser();
        String isAdmin = reportService.checkRole(user);
        List<Office> companyList = reportService.getCompanyList();
        List<Office> officeList = reportService.getOfficeList(new Office());
        List<Position> positionList = reportService.getPositionList();
        User userEntity = new User();
        Page<User> page = reportService.findUserPage(new Page<User>(1, 30), userEntity);
        // Page<User> page = reportService.findUserPage(new Page<User>(request, response), userEntity);

        //获取举报提交文件列表
        ReportAttachmentEntity reportAttachment = new ReportAttachmentEntity();
        reportAttachment.setReportId(reportEntity.getId());
        reportAttachment.setAttachmentType("0");
        List<ReportAttachmentEntity> reportAttachmentList = reportService.getAttachmentInfo(reportAttachment);
        //获取补充提交文件列表
        ReportAttachmentEntity supplementAttachment = new ReportAttachmentEntity();
        supplementAttachment.setReportId(reportEntity.getId());
        supplementAttachment.setAttachmentType("1");
        List<ReportAttachmentEntity> supplementAttachmentList = reportService.getAttachmentInfo(supplementAttachment);
        //获取处理成果文件列表
        ReportAttachmentEntity dealAttachment = new ReportAttachmentEntity();
        dealAttachment.setReportId(reportEntity.getId());
        dealAttachment.setAttachmentType("2");
        List<ReportAttachmentEntity> dealAttachmentList = reportService.getAttachmentInfo(dealAttachment);

        //跟据id查询举报信息
        ReportEntity reportEntity1 = reportService.get(reportEntity.getId());
        /*封装类型  类别数据*/
        String  SupplementTypeStr="";
        String  SupplementCategoryStr="";
        /*遍历集合*/

        if(StringUtils.isNoneBlank(reportEntity1.getSupplementType())){
             oldType=reportEntity1.getSupplementType();
            String[] getSupplementTypeStr = reportEntity1.getSupplementType().split(",");
            for (String str:getSupplementTypeStr) {
                CtBbtcBusType ctBbtcBusType = CtBbtcBusTypeService.get(str);
                if(ctBbtcBusType!=null){
                    SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                }else{
                    SupplementTypeStr = SupplementTypeStr + "--";
                }

            }
            reportEntity1.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
        }


        if(StringUtils.isNoneBlank(reportEntity1.getSupplementCategory())){
            oldCat=reportEntity1.getSupplementCategory();
            String[] getSupplementCategory = reportEntity1.getSupplementCategory().split(",");
            for (String str:getSupplementCategory) {
                CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                if(ctBbtcBusCategory!=null){
                    SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                }else{
                    SupplementCategoryStr = SupplementCategoryStr + "--";
                }
            }
            reportEntity1.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
        }





        reportEntity.setDealPerson(reportEntity.getDealPersonName());
        if (StringUtils.isBlank(reportEntity.getDealPersonName())) {
            reportEntity.setDealPerson(user.getName());
        }
        String isSendEmail = reportEntity.getIsSendEmail();
        if (StringUtils.isNotBlank(isSendEmail)) {
            if (isSendEmail.equals("1")) {
                isSendEmail = "是";
            }
        } else {
            isSendEmail = "否";
        }
        reportEntity.setIsSendEmail(isSendEmail);

        if (isAdmin.equals("1") || isAdmin.equals("2")) {
            model.addAttribute("ifClue", true);
        } else {
            if (reportEntity.getExchangeType() == null || !(reportEntity.getIfClue().equals("2"))) {
                model.addAttribute("ifClue", true);
            }
        }

        Map<String,String> typeMap=new HashMap();
        if(oldType != ""){
            String[] typeArr= oldType.split(",");
            CtBbtcBusType  ctBbtcBusType002=null;
            for (String arr:typeArr) {
                ctBbtcBusType002 = CtBbtcBusTypeService.get(arr);
                typeMap.put(ctBbtcBusType002.getName(),arr);
            }
        }

        Map<String,String> catgoryMap=new HashMap();
        if(oldCat != ""){
            String[] typeArr= oldCat.split(",");
            CtBbtcBusCategory ctBbtcBusCategory002=null;
            for (String arr:typeArr) {
                ctBbtcBusCategory002 = ctBbtcBusCategoryService.get(arr);
                catgoryMap.put(ctBbtcBusCategory002.getName(),arr);
            }
        }

        model.addAttribute("page", page);
        model.addAttribute("user", userEntity);
        model.addAttribute("userName", user.getName());
        model.addAttribute("report", reportEntity1);
        model.addAttribute("typeMap", typeMap);
        model.addAttribute("catgoryMap", catgoryMap);
        model.addAttribute("companyList", companyList);
        model.addAttribute("officeList", officeList);
        model.addAttribute("positionList", positionList);
        model.addAttribute("isAdmin", isAdmin);
        model.addAttribute("reportAttachmentList", reportAttachmentList);
        model.addAttribute("supplementAttachmentList", supplementAttachmentList);
        model.addAttribute("dealAttachmentList", dealAttachmentList);
        return "modules/report/reportTrack";
    }

    /**
     * 举报跟踪信息保存
     *
     * @param reportEntity
     * @param model
     * @return
     */
    @RequestMapping(value = "addTrack")
    public String addTrack(ReportEntity reportEntity, HttpServletRequest request, Model
            model, RedirectAttributes redirectAttributes) {

        //判断登录人的角色
        User user = UserUtils.getUser();
        String isAdmin = reportService.checkRole(user);
        String ifDone = request.getParameter("ifDone");      // 是否完成
        String ifClue = request.getParameter("ifClue");
        String transferUser = request.getParameter("exchangeAfterUser");    //选择移交人员

        if ("ifClue".equals(ifClue)) {
            reportEntity.setIfClue("1");
        } else {
            reportEntity.setIfClue("2");
        }
        if (!beanValidator(model, reportEntity)) {
            return form(reportEntity, model);
        }
        //更新举报状态
        reportEntity.setReportStatus("1");

        if ("ifDone".equals(ifDone)) {
            reportEntity.setReportStatus("2");
        }
        //判断如果是辅助管理员
        if (reportService.checkRole(user).equals("2") || reportService.updateCheckRole(transferUser).equals("辅助管理员")) {
            reportEntity.setExchangeBeforeUser(user.getId());
        }

        if (StringUtils.isBlank(reportEntity.getExchangeAfterUser())) {
            String exchangeAfterUser = reportService.findExchangeUser(reportEntity.getId());
            reportEntity.setExchangeAfterUser(exchangeAfterUser);
        }
//
        if (StringUtils.isBlank(reportEntity.getDealPersonName())) {
            reportEntity.setDealPersonName(reportEntity.getDealPerson());
        }
        reportService.saveTrack(reportEntity, transferUser);

        if (StringUtils.isNotBlank(transferUser) && StringUtils.isBlank(reportEntity.getDealResult())) {
            //管理员移交给他人处理
            reportService.addNotice(reportEntity, "transfer", ifDone);
            reportService.addRecord(reportEntity, "1");
        } else if (StringUtils.isNotBlank(reportEntity.getDealResult()) && StringUtils.isBlank(transferUser)) {
            //自行处理
            if (!(StringUtils.isBlank(ifDone))) {
                reportService.addNotice(reportEntity, "answer", ifDone);
            }
        } else if (StringUtils.isNotBlank(transferUser) && StringUtils.isNotBlank(reportEntity.getDealResult())) {
            //管理员进行处理，同时移交给他人
            reportService.addNotice(reportEntity, "meanWhile", ifDone);
        }
        addMessage(redirectAttributes, "补充举报" + reportEntity.getSupplementTitle() + "'成功");
        return "redirect:" + adminPath + "/report/list/?repage&flag=0";
    }

    /**
     * 移交列表
     *
     * @param user
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "viewTransfer")
    public void viewTransfer(User user, String flag, HttpServletRequest request, HttpServletResponse
            response, Model model,Integer pageNo,Integer pageSize) throws IOException {

        Page<User> page = reportService.findUserPage(new Page<User>(pageNo, pageSize), user);
        StringBuffer html = new StringBuffer();
        html.append("<table id='contentTable' class='table table-striped table-bordered table-condensed'>");
        html.append("	<thead>");
        html.append("	<tr>");
        if (flag.equals("1")) {//移交
            html.append("		<th>选择</th>");
            html.append("		<th>ID</th>");
            html.append("		<th>员工号</th>");
            html.append("		<th>姓名</th>");
            html.append("		<th>手机号</th>");
            html.append("		<th>所属公司</th>");
            html.append("		<th>所属部门</th>");
            html.append("		<th>职位</th>");
        } else if (flag.equals("2")) {//转交
            html.append("		<th>选择</th>");
            html.append("		<th>ID</th>");
            html.append("		<th>用户名</th>");
            html.append("		<th>姓名</th>");
            html.append("		<th>组织</th>");
            html.append("		<th>手机号码</th>");
            html.append("		<th>角色</th>");
        }
        html.append("	</tr>");
        html.append("	</thead>");
        html.append("	<tbody>");
        if (page.getList().size() > 0) {
            int i = 1;
            for (User userEntity : page.getList()) {
                html.append("			<tr>");
                if (flag.equals("1")) {
                    html.append("				<td><input type='radio' value='" + userEntity.getId() + "'></td>");
                    html.append("				<td>" + i + "</td>");
                    html.append("				<td>" + (userEntity.getNo() == null ? "" : userEntity.getNo()) + "</td>");
                    html.append("				<td>" + (userEntity.getName() == null ? "" : userEntity.getName()) + "</td>");
                    html.append("				<td>" + (userEntity.getMobile() == null ? "" : userEntity.getMobile()) + "</td>");
                    html.append("				<td>" + (userEntity.getCompany() == null ? "" : userEntity.getCompany().getName()) + "</td>");
                    html.append("				<td>" + (userEntity.getOffice() == null ? "" : userEntity.getOffice().getName()) + "</td>");
                    if (userEntity.getPosition() != null) {
                        html.append("				<td>" + (userEntity.getPosition().getName() == null ? "" : userEntity.getPosition().getName()) + "</td>");
                    } else {
                        html.append("				<td></td>");
                    }
                } else if (flag.equals("2")) {
                    html.append("				<td><input type='radio' value='" + userEntity.getId() + "' onclick='chooseRen(this);'></td>");
                    html.append("				<td>" + i + "</td>");
                    html.append("				<td>" + (userEntity.getLoginName() == null ? "" : userEntity.getLoginName()) + "</td>");
                    html.append("				<td>" + (userEntity.getName() == null ? "" : userEntity.getName()) + "</td>");
                    html.append("				<td>" + (userEntity.getDevision() == null ? "" : userEntity.getDevision()) + "</td>");
                    html.append("				<td>" + (userEntity.getMobile() == null ? "" : userEntity.getMobile()) + "</td>");
                    html.append("				<td>" + (userEntity.getRole().getName() == null ? "" : userEntity.getRole().getName()) + "</td>");
                }
                html.append("			</tr>");
                i++;
            }
        }
        html.append("	</tbody>");
        html.append("</table>");
        html.append("<span id='chooseItem'></span>");
        if (page.getList().size() == 0) {
            html.append("	<span style='color: #999999;margin: 20px 0 70px 20px;display: block;'>未查询到相关内容</span>");
        }
        if (page.getList().size() > 0) {
            html.append("	<div class='pagination'>" + page + "</div>");
        }
        PrintWriter out = response.getWriter();
        response.setContentType("application/json;charset=utf-8");
        out.write(html.toString());
        out.close();
    }

    /**
     * 集团列表导出
     *
     * @param reportEntity
     * @param flag
     * @param request
     * @param response
     * @param redirectAttributes
     * @return
     */
    @RequestMapping(value = "export", method = RequestMethod.POST)
    public String export(ReportEntity reportEntity, String flag, HttpServletRequest
            request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        //判断登录人的角色
        User user = UserUtils.getUser();
        String isAdmin = reportService.checkRole(user);
        //判断标签状态 flag为空，跳转到核查中举报列表 flag为0，跳转到未处理举报列表 flag为1，跳转到举报列表
        if (StringUtils.isNotBlank(flag)) {
            if (flag.equals("0")) {
                if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                    reportEntity.setReportStatus("0");
                }
            } else {
                if (flag.equals("4")) {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setDealResult("7");
                        reportEntity.setFlage("1");
                    }
                } else {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setReportStatus("1");
                    }
                }
            }
        }
        try {
            String fileName = "举报列表" + DateUtils.getDate("yyyyMMddHHmmss") + ".xlsx";
            List<ReportEntity> reportList = null;

            if ((!reportService.checkRole(user).equals("1")) && (!reportService.checkRole(user).equals("2"))) {
                reportEntity.setExchangeAfterUser(user.getId());
                reportList = reportService.getReportList(reportEntity);
            } else if (reportService.checkRole(user).equals("2")) {
                reportEntity.setIsFzAdmin("2");
                reportEntity.setExchangeBeforeUser(user.getId());
                reportList = reportService.getReportList(reportEntity);
            } else {
                reportEntity.setIsAdmin("1");
                reportList = reportService.getReportList(reportEntity);
            }

                new ExportExcel("举报列表", ReportEntity.class, isAdmin).setDataList(reportList).write(request, response, fileName).dispose();
            return null;
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出用户失败！失败信息：" + e.getMessage());
        }
        return "redirect:" + adminPath + "/report/list/?repage&flag=" + flag;
    }

    /**
     * 区域列表导出
     *
     * @param reportEntity
     * @param flag
     * @param request
     * @param response
     * @param redirectAttributes
     * @return
     */
    @RequestMapping(value = "qyexport", method = RequestMethod.POST)
    public String qyexport(ReportEntity reportEntity, String flag, HttpServletRequest
            request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        //判断登录人的角色
        User user = UserUtils.getUser();
        String isAdmin = reportService.checkRole(user);
        //判断标签状态 flag为空，跳转到核查中举报列表 flag为0，跳转到未处理举报列表 flag为1，跳转到举报列表
        if (StringUtils.isNotBlank(flag)) {
            if (flag.equals("0")) {
                if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                    reportEntity.setReportStatus("0");
                }
            } else {
                if (flag.equals("4")) {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setDealResult("7");
                        reportEntity.setFlage("1");
                    }
                } else {
                    if (StringUtils.isBlank(reportEntity.getReportStatus())) {
                        reportEntity.setReportStatus("1");
                    }
                }
            }
        }
        try {
            String fileName = "举报列表" + DateUtils.getDate("yyyyMMddHHmmss") + ".xlsx";
            List<ReportEntity> reportList = null;
//            if (!(reportService.checkRole(user).equals("1"))) {
//                reportEntity.setExchangeAfterUser(user.getId());
//                reportList = reportService.getReportQyList(reportEntity);
//            } else {
//                reportEntity.setIsAdmin(user.getId());
//                reportList = reportService.getReportQyList(reportEntity);
//            }
            if ((!reportService.checkRole(user).equals("1")) && (!reportService.checkRole(user).equals("2"))) {
                reportEntity.setExchangeAfterUser(user.getId());
                reportList = reportService.getReportQyList(reportEntity);
            } else if (reportService.checkRole(user).equals("2")) {
                reportEntity.setIsFzAdmin("2");
                reportEntity.setExchangeBeforeUser(user.getId());
                reportList = reportService.getReportQyList(reportEntity);
            } else {
                reportEntity.setIsAdmin("1");
                reportList = reportService.getReportQyList(reportEntity);
            }

            new ExportExcel("举报列表", ReportEntity.class, isAdmin).setDataList(reportList).write(request, response, fileName).dispose();
            return null;
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出用户失败！失败信息：" + e.getMessage());
        }
        return "redirect:" + adminPath + "/report/list/?repage&flag=" + flag;
    }


    /**
     * 转交列表
     *
     * @param reportEntity
     * @param model
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "deliverList")
    public String deliverList(ReportEntity reportEntity, HttpServletRequest request, HttpServletResponse
            response, Model model) {
        //判断登录人的角色
        User user = UserUtils.getUser();
        if (!reportService.checkRole(user).equals("1")) {

            reportEntity.setExchangeAfterUser(user.getId());
        }
        User userEntity = new User();
        //查询分配用户
        Page<User> userPage = reportService.findUserPage(new Page<User>(1, 20), userEntity);
        //查询移交数据
        Page<ReportEntity> page = reportService.getChooseReportPage(new Page<ReportEntity>(request, response), reportEntity);

        List<ReportEntity> reportlist = page.getList();
        for (ReportEntity  reportEntity1:reportlist) {

            /*封装类型  类别数据*/
            String SupplementTypeStr = "";
            String SupplementCategoryStr = "";
            /*遍历集合*/

            if (StringUtils.isNoneBlank(reportEntity1.getSupplementType())) {
                String[] getSupplementTypeStr = reportEntity1.getSupplementType().split(",");
                for (String str : getSupplementTypeStr) {
                    CtBbtcBusType ctBbtcBusType = CtBbtcBusTypeService.get(str);
                    if (ctBbtcBusType != null) {
                        SupplementTypeStr = SupplementTypeStr + ctBbtcBusType.getName() + ",";
                    } else {
                        SupplementTypeStr = SupplementTypeStr + "--";
                    }

                }
                reportEntity1.setSupplementType(SupplementTypeStr.substring( 0,  SupplementTypeStr.length()-1));
            }


            if (StringUtils.isNoneBlank(reportEntity1.getSupplementCategory())) {
                String[] getSupplementCategory = reportEntity1.getSupplementCategory().split(",");
                for (String str : getSupplementCategory) {
                    CtBbtcBusCategory ctBbtcBusCategory = ctBbtcBusCategoryService.get(str);
                    if (ctBbtcBusCategory != null) {
                        SupplementCategoryStr = SupplementCategoryStr + ctBbtcBusCategory.getName() + ",";
                    } else {
                        SupplementCategoryStr = SupplementCategoryStr + "--";
                    }
                }
                reportEntity1.setSupplementCategory(SupplementCategoryStr.substring(0,SupplementCategoryStr.length()-1));
            }



        }

        page.setList(reportlist);
        model.addAttribute("page", page);
        model.addAttribute("userPage", userPage);
        model.addAttribute("user", userEntity);
        model.addAttribute("report", reportEntity);
        return "modules/report/reportDeliver";
    }

    /**
     * 转交操作
     *
     * @param reportIds
     * @param userId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "deliver")
    public void deliver(String[] reportIds, String userId, HttpServletRequest request, HttpServletResponse
            response) throws IOException {
        reportService.deliverReport(reportIds, userId);
        String result = "1";
        PrintWriter out = response.getWriter();
        response.setContentType("application/json;charset=utf-8");
        out.write(result);
        out.close();
    }

    @RequestMapping("recordEmail")
    public void recordEmail(String reportId, HttpServletResponse response) throws IOException {
        int result = reportService.updateIsSendEmail(reportId);
        PrintWriter out = response.getWriter();
        response.setContentType("application/json;charset=utf-8");
        out.write(result);
        out.close();
    }

    /**
     * 管理员修改处理结论
     *
     * @return
     */
    @RequestMapping(value = "conclusion")
    public String closeConclusion(ReportEntity reportEntity) {
        reportService.updateConclusion(reportEntity);
        return "redirect:" + adminPath + "/report/list/?repage&flag=0";
    }

    /**
     * 删除举报记录
     *
     * @return
     */
    @RequestMapping(value = "deleteconclusion")
    public String deleteConclusion(String id) {
        ReportEntity reportEntity = new ReportEntity();
        reportEntity.setId(id);
        reportService.deleteConclusion(reportEntity);

        return "redirect:" + adminPath + "/report/list/?repage&flag=0";
    }

    /**
     * 管理员重新跟踪
     *
     * @return
     */
    @RequestMapping(value = "again")
    public String againConclusion(ReportEntity reportEntity) {
        reportService.againUpdateConclusion(reportEntity);
        return "redirect:" + adminPath + "/report/list/?repage&flag=1";
    }

    /**
     * 转为线索
     *
     * @return
     */
    @RequestMapping(value = "clues")
    public String cluesConclusion(ReportEntity reportEntity) {

        reportService.cluesUpdateConclusion(reportEntity);
        return "redirect:" + adminPath + "/report/list/?repage&flag=4";
    }


    /**
     * 获取系统有效用户
     *
     * @return //
     */
    private static ReportDao userReportDao = SpringContextHolder.getBean(ReportDao.class);

    public static List<User> getTransferName() {
        List<User> userList = Lists.newArrayList();
        userList = userReportDao.findAllUserList();
        return userList;
    }

}
