package com.ejweb.modules.report.utils;

import com.ejweb.modules.report.dao.ReportDao;
import com.ejweb.modules.report.entity.ReportEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.Calendar;

/**
 * Created by haoqm on 2019/7/18.
 */
@Service
@Lazy(false)
public class TimedTask {

    @Autowired
    private ReportDao reportDao;

    @Scheduled(cron="0 0 12 * * ?")   //cron表达式   每天下午6点执行
    public void job1() {
        //获取所有转为线索的举报信息
        ReportEntity reportEntity=new ReportEntity();
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, -3);    // 当前日期减三个月  生产环境
      /*  c.add(Calendar.MINUTE, -25);    // 当前日期减去25分钟   测试环境 */
        reportEntity.setTransTime(c.getTime());
        try{
            /*跟据三个月前的过期时间查询并修改当天过期的举报信息*/
            reportDao.updateReportByClueTime(reportEntity);
            System.out.println("线索状态改变成功+1");
        }catch (Exception e){
            System.out.println("线索状态改变异常");
        }


    }
}
