package com.ejweb.core.push;

import java.net.URLEncoder;

import com.alibaba.fastjson.JSONObject;

public class ProductPayload {

    private final JSONObject _data = new JSONObject();
    private String code = null;
    
    public ProductPayload(){
        
    }
    public ProductPayload setServerToken(String serverToken){
        
        this.code = serverToken;
        return this;
    }
    public ProductPayload setPushToken(String pushToken){
        
        _data.put("token", pushToken);
        return this;
    }
    public ProductPayload setProductName(String productName){
        
        _data.put("name", productName);
        return this;
    }
    public ProductPayload setDescription(String description){
        
        _data.put("description", description);
        return this;
    }
    public ProductPayload setAppPackageName(String appPackageName){
        
        _data.put("package", appPackageName);
        return this;
    }
    
    public final static ProductPayload newPayload(){
        final ProductPayload payload = new ProductPayload();
        return payload;
    }
    public byte[] getMessagePayload(){
        try {
            
            String c = "code="+code+"&content="+URLEncoder.encode(_data.toJSONString(), "UTF-8");
            return c.getBytes("UTF-8");
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
    @Override
    public String toString() {
        // TODO Auto-generated method stub
        try {
            
            return "code="+code+"&content="+URLEncoder.encode(_data.toJSONString(), "UTF-8");
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
}
